untrusted comment: verify with openbsd-76-base.pub
RWTkuwn4mbq8onyzue4hfBLbIEo0jGopFMVcjqkmx1ZFHBG5tPYbM1XIR3xz8g/lY6+DkTXhMNQyIOD/RNDjotgeaO6PyKgC4QM=

OpenBSD 7.6 errata 017, June 17, 2025:

When using syncookies in pf(4), new TCP connections could run into
timeout due to integer underflow.

Apply by doing:
    signify -Vep /etc/signify/openbsd-76-base.pub -x 017_pfsyncook.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net/pf.c
===================================================================
RCS file: /cvs/src/sys/net/pf.c,v
diff -u -p -r1.1205 pf.c
--- sys/net/pf.c	4 Sep 2024 07:54:52 -0000	1.1205
+++ sys/net/pf.c	3 Jun 2025 13:54:46 -0000
@@ -382,7 +382,7 @@ pf_set_protostate(struct pf_state *st, i
 	    !(TCPS_HAVEESTABLISHED(st->src.state) ||
 	    st->src.state == TCPS_CLOSED) &&
 	    (TCPS_HAVEESTABLISHED(newstate) || newstate == TCPS_CLOSED))
-		pf_status.states_halfopen--;
+		atomic_dec_int(&pf_status.states_halfopen);
 
 	st->src.state = newstate;
 }
@@ -4677,7 +4677,7 @@ pf_create_state(struct pf_pdesc *pd, str
 		pf_set_protostate(st, PF_PEER_SRC, TCPS_SYN_SENT);
 		pf_set_protostate(st, PF_PEER_DST, TCPS_CLOSED);
 		st->timeout = PFTM_TCP_FIRST_PACKET;
-		pf_status.states_halfopen++;
+		atomic_inc_int(&pf_status.states_halfopen);
 		break;
 	case IPPROTO_UDP:
 		pf_set_protostate(st, PF_PEER_SRC, PFUDPS_SINGLE);
