untrusted comment: verify with openbsd-64-base.pub
RWQq6XmS4eDAcT7iguLT8P2N4KVuxYXFb9rqG8JKe0uVSFR+dDlXh5TMkn8zF8IdAJrJRVOGSb9TxFjWlPKtBZLT/57ZH2pv0gk=

OpenBSD 6.4 errata 007, November 29, 2018

The mail.mda and mail.lmtp delivery agents were not reporting temporary
failures correctly, causing smtpd to bounce messages in some cases where
it should have retried them.

Apply by doing:
    signify -Vep /etc/signify/openbsd-64-base.pub -x 007_smtpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install smtpd:
    cd /usr/src/usr.sbin/smtpd
    make obj
    make
    make install

Index: usr.sbin/smtpd/mail.lmtp.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/mail.lmtp.c,v
diff -u -p -r1.3 -r1.4
--- usr.sbin/smtpd/mail.lmtp.c	29 May 2018 22:16:15 -0000	1.3
+++ usr.sbin/smtpd/mail.lmtp.c	21 Oct 2018 18:22:50 -0000	1.4
@@ -25,6 +25,7 @@
 #include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
+#include <sysexits.h>
 #include <unistd.h>
 
 enum phase {
@@ -167,7 +168,7 @@ lmtp_connect_inet(const char *destinatio
 
 	freeaddrinfo(res0);
 	if (s == -1)
-		errx(1, "%s", cause);
+		errx(EX_TEMPFAIL, "%s", cause);
 
 	return fdopen(s, "r+");
 }
@@ -191,7 +192,7 @@ lmtp_connect_unix(const char *destinatio
 		errx(1, "unix: socket path is too long");
 
 	if (connect(s, (struct sockaddr *)&addr, sizeof addr) == -1)
-		err(1, "connect");
+		err(EX_TEMPFAIL, "connect");
 
 	return fdopen(s, "r+");
 }
Index: usr.sbin/smtpd/mail.mda.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/mail.mda.c,v
diff -u -p -r1.2 -r1.3
--- usr.sbin/smtpd/mail.mda.c	28 Apr 2018 10:37:20 -0000	1.2
+++ usr.sbin/smtpd/mail.mda.c	25 Nov 2018 17:34:00 -0000	1.3
@@ -16,6 +16,7 @@
 
 #include <sys/types.h>
 #include <sys/stat.h>
+#include <sys/wait.h>
 
 #include <ctype.h>
 #include <err.h>
@@ -26,12 +27,14 @@
 #include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
+#include <sysexits.h>
 #include <unistd.h>
 
 int
 main(int argc, char *argv[])
 {
 	int ch;
+	int ret;
 
 	if (! geteuid())
 		errx(1, "mail.mda: may not be executed as root");
@@ -51,5 +54,15 @@ main(int argc, char *argv[])
 	if (argc > 1)
 		errx(1, "mail.mda: only one command is supported");
 
-	return system(argv[0]) == 0 ? 0 : 1;
+	/* could not obtain a shell or could not obtain wait status,
+	 * tempfail */
+	if ((ret = system(argv[0])) == -1)
+		errx(EX_TEMPFAIL, "%s", strerror(errno));
+
+	/* not exited properly but we have no details,
+	 * tempfail */
+	if (! WIFEXITED(ret))
+		exit(EX_TEMPFAIL);
+
+	exit(WEXITSTATUS(ret));
 }
