untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEjvNWv+W/GvT56GObu5bRXKfJ0ZRLp5Swxbv+XpFT7akIVsWcDf2Fot016oOpMSpu4f7hMxC0Vu7zLV3KI1vngM=

OpenBSD 6.1 errata 022, August 3, 2017:

An uninitialized variable in fcntl() may result in an info leak.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 022_fcntl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/kern_descrip.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_descrip.c,v
--- sys/kern/kern_descrip.c	11 Feb 2017 19:51:06 -0000	1.140
+++ sys/kern/kern_descrip.c	20 Jul 2017 16:47:21 -0000	1.141
@@ -435,6 +435,7 @@ restart:
 			*retval = ((struct pipe *)fp->f_data)->pipe_pgid;
 			break;
 		}
+		tmp = 0;
 		error = (*fp->f_ops->fo_ioctl)
 			(fp, TIOCGPGRP, (caddr_t)&tmp, p);
 		*retval = -tmp;
