/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias.canonicalize;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import io.mola.galimatias.canonicalize.URLCanonicalizer;
import java.util.ArrayList;
import java.util.List;

public class CombinedCanonicalizer
implements URLCanonicalizer {
    private final List<URLCanonicalizer> canonicalizers = new ArrayList<URLCanonicalizer>();

    public CombinedCanonicalizer(URLCanonicalizer ... canons) {
        for (URLCanonicalizer canon : canons) {
            if (canon instanceof CombinedCanonicalizer) {
                this.canonicalizers.addAll(((CombinedCanonicalizer)canon).canonicalizers);
                continue;
            }
            this.canonicalizers.add(canon);
        }
    }

    @Override
    public URL canonicalize(URL input) throws GalimatiasParseException {
        URL result = input;
        for (URLCanonicalizer canon : this.canonicalizers) {
            result = canon.canonicalize(result);
        }
        return result;
    }
}

