/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.autoupdate.members.prefs;

import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class MemberPrefs {
    private static final Logger LOG = Logger.getLogger("au.com.trgtd.tr.autoupdate.members.prefs");
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/2.2.1/autoupdate");
    public static final String KEY_MEMBER_USERNAME = "member.username";
    public static final String KEY_MEMBER_PASSWORD = "member.password";
    public static final String KEY_UPDATES = "member.get.updates";
    public static final String KEY_BETA_UPDATES = "member.get.beta.updates";

    public static final String getMemberUsername() {
        return prefs.get(KEY_MEMBER_USERNAME, "");
    }

    public static final void setMemberUsername(String value) {
        prefs.put(KEY_MEMBER_USERNAME, value);
        MemberPrefs.flush();
    }

    public static final String getMemberPassword() {
        return prefs.get(KEY_MEMBER_PASSWORD, "");
    }

    public static final void setMemberPassword(String value) {
        prefs.put(KEY_MEMBER_PASSWORD, value);
        MemberPrefs.flush();
    }

    public static final boolean isGetUpdates() {
        return prefs.getBoolean(KEY_UPDATES, true);
    }

    public static final void setGetUpdates(boolean value) {
        prefs.putBoolean(KEY_UPDATES, value);
        MemberPrefs.flush();
    }

    public static final boolean isGetBetaUpdates() {
        return prefs.getBoolean(KEY_BETA_UPDATES, false);
    }

    public static final void setGetBetaUpdates(boolean value) {
        prefs.putBoolean(KEY_BETA_UPDATES, value);
        MemberPrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Member autoupdate preferences error. " + ex.getMessage());
        }
    }
}

