---
search:
  exclude: true
---

###Dec 2014

####Bug fixes
 - Fixed Global Search box bootstrap ([PR357](https://github.com/librenms/librenms/pull/357))
 - Fixed display issues when calculating CDR in billing system ([PR359](https://github.com/librenms/librenms/pull/359))
 - Fixed API route order to resolve get_port_graphs working ([PR364](https://github.com/librenms/librenms/pull/364))

####Improvements
 - Added new API route to retrieve list of graphs for a device ([PR355](https://github.com/librenms/librenms/pull/355))
 - Added new API route to retrieve list of port for a device ([PR356](https://github.com/librenms/librenms/pull/356))
 - Added new API route to retrieve billing info ([PR360](https://github.com/librenms/librenms/pull/360))
 - Added alerting system ([PR370](https://github.com/librenms/librenms/pull/370), [PR369](https://github.com/librenms/librenms/pull/369), [PR367](https://github.com/librenms/librenms/pull/367))
 - Added dbSchema version to about page ([PR377](https://github.com/librenms/librenms/pull/377))
 - Added git log link to about page ([PR378](https://github.com/librenms/librenms/pull/378))
 - Added Two factor authentication ([PR383](https://github.com/librenms/librenms/pull/383))

###Nov 2014

####Bug fixes
 - Updated Alcatel-Lucent OmniSwitch detection ([PR340](https://github.com/librenms/librenms/pull/340))
 - Added fix for DLink port detection ([PR347](https://github.com/librenms/librenms/pull/347))
 - Fixed BGP session count ([PR334](https://github.com/librenms/librenms/pull/334))
 - Fixed errors with BGP polling and storing data in RRD ([PR346](https://github.com/librenms/librenms/pull/346))

####Improvements
 - Added option to clean old perf_times table entries ([PR343](https://github.com/librenms/librenms/pull/343))
 - Added nginx+php-fpm instructions ([PR345](https://github.com/librenms/librenms/pull/345))
 - Added BGP route to API ([PR335](https://github.com/librenms/librenms/pull/335))
 - Updated check_mk to new version + removed Observium branding ([PR311](https://github.com/librenms/librenms/pull/311))
 - Updated Edit SNMP settings page for device to only show relevant SNMP options ([PR317](https://github.com/librenms/librenms/pull/317))
 - Eventlog page now uses paged results ([PR336](https://github.com/librenms/librenms/pull/336))
 - Added new API route to show peering, transit and core graphs ([PR349](https://github.com/librenms/librenms/pull/349))
 - Added VyOS and EdgeOS detection ([PR351](https://github.com/librenms/librenms/pull/351) / [PR352](https://github.com/librenms/librenms/pull/352))
 - Documentation style and markdown updates ([PR353](https://github.com/librenms/librenms/pull/353))

###Oct 2014

####Bug fixes
 - Fixed displaying device image in device list ([PR296](https://github.com/librenms/librenms/pull/296))
 - Fixed placement of popups ([PR297](https://github.com/librenms/librenms/pull/297))
 - Updated authToken response code in API to 401 ([PR310](https://github.com/librenms/librenms/pull/310))
 - Removed trailing / from v0 part of API url ([PR312](https://github.com/librenms/librenms/pull/312))
 - Added correct response code for API call get_vlans ([PR313](https://github.com/librenms/librenms/pull/313))
 - Updated yearly graphs to fix year variable being passed ([PR316](https://github.com/librenms/librenms/pull/316))
 - Updated transport list to be generated from $config ([PR318](https://github.com/librenms/librenms/pull/318))
 - Moved addhost button on add host page as it was hidden ([PR319](https://github.com/librenms/librenms/pull/319))
 - Added stripslashes to hrdevice page ([PR321](https://github.com/librenms/librenms/pull/321))
 - Fixed web installer issue due to variable name change ([PR325](https://github.com/librenms/librenms/pull/325))
 - Updated disabled field in api tokens ([PR327](https://github.com/librenms/librenms/pull/327))
 - Fixed daily.sh not running from outside install directory (cron) ([PR328](https://github.com/librenms/librenms/pull/328))
 - Removed --no-edit from daily.php git pull ([PR309](https://github.com/librenms/librenms/pull/309))

####Improvements
 - Added ability to create api tokens ([PR294](https://github.com/librenms/librenms/pull/294))
 - Added icmp and poller graphs for devices ([PR295](https://github.com/librenms/librenms/pull/295))
 - Added urldecode/urlencode support for interface names in API ([PR298](https://github.com/librenms/librenms/pull/298))
 - Added new library to support on screen notifications ([PR300](https://github.com/librenms/librenms/pull/300))
 - Added authlog purge function and improved efficiency in clearing syslog table ([PR301](https://github.com/librenms/librenms/pull/301))
 - Updated addhost page to show relevant snmp options ([PR303](https://github.com/librenms/librenms/pull/303))
 - Added limit $config for front page boxes ([PR305](https://github.com/librenms/librenms/pull/305))
 - Updated http-auth adding user to check if user already exists ([PR307](https://github.com/librenms/librenms/pull/307))
 - Added names to all API routes ([PR314](https://github.com/librenms/librenms/pull/314))
 - Added route to call list of API endpoints ([PR315](https://github.com/librenms/librenms/pull/315))
 - Added options to $config to specify fping retry and timeout ([PR323](https://github.com/librenms/librenms/pull/323))
 - Added icmp / snmp to device down alerts for debugging ([PR324](https://github.com/librenms/librenms/pull/324))
 - Added function to page results for large result pages ([PR333](https://github.com/librenms/librenms/pull/333))

###Sep 2014

####Bug fixes
 - Updated vtpversion check to fix vlan discovery issues ([PR289](https://github.com/librenms/librenms/pull/289))
 - Fixed mac address change false positives ([PR292](https://github.com/librenms/librenms/pull/292))

####Improvements
 - Hide snmp passwords on edit snmp form ([PR290](https://github.com/librenms/librenms/pull/290))
 - Updates to API ([PR291](https://github.com/librenms/librenms/pull/291))

###Aug 2014

####Bug fixes
 - Disk % not showing in health view ([PR284](https://github.com/librenms/librenms/pull/284))
 - Fixed layout issue for ports list ([PR286](https://github.com/librenms/librenms/pull/286))
 - Removed session regeneration ([PR287](https://github.com/librenms/librenms/pull/287))
 - Updated edit button on edit user screen ([PR288](https://github.com/librenms/librenms/pull/288))

####Improvements
 - Added email field for add user form ([PR278](https://github.com/librenms/librenms/pull/278))
 - V0 of API release ([PR282](https://github.com/librenms/librenms/pull/282))

###Jul 2014

####Bug fixes
 - Fixed RRD creation using MAX twice ([PR266](https://github.com/librenms/librenms/pull/266))
 - Fixed variables leaking in poller run ([PR267](https://github.com/librenms/librenms/pull/267))
 - Fixed links to health graphs ([PR271](https://github.com/librenms/librenms/pull/271))
 - Fixed install docs to remove duplicate snmpd on install ([PR276](https://github.com/librenms/librenms/pull/276))

####Improvements
 - Added support for Cisco ASA connection graphs ([PR268](https://github.com/librenms/librenms/pull/268))
 - Updated delete device page ([PR270](https://github.com/librenms/librenms/pull/270))

###Jun 2014

####Bug fixes
 - Fixed a couple of DB queries ([PR222](https://github.com/librenms/librenms/pull/222))
 - Fixes to make interface more mobile friendly ([PR227](https://github.com/librenms/librenms/pull/227))
 - Fixed link to device on overview apps page ([PR228](https://github.com/librenms/librenms/pull/228))
 - Fixed missing backticks on SQL queries ([PR253](https://github.com/librenms/librenms/pull/253) / [PR254](https://github.com/librenms/librenms/pull/254))
 - Fixed user permissions page ([PR265](https://github.com/librenms/librenms/pull/265))

####Improvements
 - Updated index page ([PR224](https://github.com/librenms/librenms/pull/224))
 - Updated global search visually ([PR223](https://github.com/librenms/librenms/pull/223))
 - Added contributors agreement ([PR225](https://github.com/librenms/librenms/pull/225))
 - Added ability to update health values ([PR226](https://github.com/librenms/librenms/pull/226))
 - Tidied up search box on devices list page ([PR229](https://github.com/librenms/librenms/pull/229))
 - Updated port search box and port table list ([PR230](https://github.com/librenms/librenms/pull/230))
 - Removed some unused javascript libraries ([PR231](https://github.com/librenms/librenms/pull/231))
 - Updated year and column for vertical status summary ([PR232](https://github.com/librenms/librenms/pull/232))
 - Tidied up the delete user page ([PR235](https://github.com/librenms/librenms/pull/235))
 - Added snmp port to $config ([PR237](https://github.com/librenms/librenms/pull/237))
 - Added documentation for lighttpd ([PR238](https://github.com/librenms/librenms/pull/238))
 - Updated all device edit pages ([PR239](https://github.com/librenms/librenms/pull/239))
 - Added IPv6 only host support ([PR241](https://github.com/librenms/librenms/pull/241))
 - Added public status page ([PR246](https://github.com/librenms/librenms/pull/246))
 - Added validate_device_id function ([PR257](https://github.com/librenms/librenms/pull/257))
 - Added auto detect of install location ([PR259](https://github.com/librenms/librenms/pull/259))

###Mar 2014

####Bug fixes
 - Removed link to pdf in billing history ([PR146](https://github.com/librenms/librenms/pull/146))
 - librenms logs now saved in correct location ([PR163](https://github.com/librenms/librenms/pull/163))
 - Updated pfsense detection ([PR182](https://github.com/librenms/librenms/pull/182))
 - Fixed health page mini cpu ([PR195](https://github.com/librenms/librenms/pull/195))
 - Updated install docs to include php5-json ([PR196](https://github.com/librenms/librenms/pull/196))
 - Fixed Dlink interface names ([PR200](https://github.com/librenms/librenms/pull/200) / [PR203](https://github.com/librenms/librenms/pull/203))
 - Stop shortening IP in shorthost function ([PR210](https://github.com/librenms/librenms/pull/210))
 - Fixed status box overlapping ([PR211](https://github.com/librenms/librenms/pull/211))
 - Fixed top port overlay issue ([PR212](https://github.com/librenms/librenms/pull/212))
 - Updated docs and daily.sh to update DB schemas ([PR215](https://github.com/librenms/librenms/pull/215))
 - Updated hardware detection for RouterOS ([PR217](https://github.com/librenms/librenms/pull/217))
 - Restore _GET variables for logging in ([PR218](https://github.com/librenms/librenms/pull/218))

####Improvements
 - Updated inventory page to use bootstrap ([PR141](https://github.com/librenms/librenms/pull/141))
 - Updated mac / arp pages to use bootstrap ([PR147](https://github.com/librenms/librenms/pull/147))
 - Updated devices page to use bootstrap ([PR149](https://github.com/librenms/librenms/pull/149))
 - Updated delete host page to use bootstrap ([PR151](https://github.com/librenms/librenms/pull/151))
 - Updated print_error function to use bootstrap ([PR153](https://github.com/librenms/librenms/pull/153))
 - Updated install docs for Apache 2.3 > ([PR161](https://github.com/librenms/librenms/pull/161))
 - Upgraded PHPMailer ([PR169](https://github.com/librenms/librenms/pull/169))
 - Added send_mail function using PHPMailer ([PR170](https://github.com/librenms/librenms/pull/170))
 - Added new and awesome IRC Bot ([PR171](https://github.com/librenms/librenms/pull/171))
 - Added Gentoo detection and logo ([PR174](https://github.com/librenms/librenms/pull/174) / [PR179](https://github.com/librenms/librenms/pull/179))
 - Added Engenius detection ([PR186](https://github.com/librenms/librenms/pull/186))
 - Updated edit user to enable editing ([PR187](https://github.com/librenms/librenms/pull/187))
 - Added EAP600 engenius support ([PR188](https://github.com/librenms/librenms/pull/188))
 - Added Plugin system ([PR189](https://github.com/librenms/librenms/pull/189))
 - MySQL calls updated to use dbFacile ([PR190](https://github.com/librenms/librenms/pull/190))
 - Added support for Dlink devices ([PR193](https://github.com/librenms/librenms/pull/193))
 - Added Windows 2012 polling support ([PR201](https://github.com/librenms/librenms/pull/201))
 - Added purge options for syslog / eventlog ([PR204](https://github.com/librenms/librenms/pull/204))
 - Added BGP to global search box ([PR205](https://github.com/librenms/librenms/pull/205))

###Feb 2014

####Bug fixes
 - Set poller-wrapper.py to be executable ([PR89](https://github.com/librenms/librenms/pull/89))
 - Fix device/port down boxes ([PR99](https://github.com/librenms/librenms/pull/99))
 - Ports set to be ignored honoured for threshold alerts ([PR104](https://github.com/librenms/librenms/pull/104))
 - Added PasswordHash.php to adduser.php ([PR119](https://github.com/librenms/librenms/pull/119))
 - build-base.php update to run DB updates ([PR128](https://github.com/librenms/librenms/pull/128))

####Improvements
 - Added web based installer ([PR75](https://github.com/librenms/librenms/pull/75))
 - Updated login page design ([PR78](https://github.com/librenms/librenms/pull/78))
 - Ability to enable / disable topX boxes ([PR100](https://github.com/librenms/librenms/pull/100))
 - Added PHPPass support for MySQL auth logins ([PR101](https://github.com/librenms/librenms/pull/101))
 - Updated to Bootstrap 3.1 ([PR106](https://github.com/librenms/librenms/pull/106))
 - index.php tidied up ([PR107](https://github.com/librenms/librenms/pull/107))
 - Updated device overview page design ([PR113](https://github.com/librenms/librenms/pull/113))
 - Updated print_optionbar* to use bootstrap ([PR115](https://github.com/librenms/librenms/pull/115))
 - Updated device/port/services box to use bootstrap ([PR117](https://github.com/librenms/librenms/pull/117))
 - Updated eventlog / syslog to use bootstrap ([PR132](https://github.com/librenms/librenms/pull/132) / [PR134](https://github.com/librenms/librenms/pull/134))

###Jan 2014

####Bug fixes
 - Moved location redirect for logout ([PR55](https://github.com/librenms/librenms/pull/55))
 - Remove debug statements from process_syslog ([PR57](https://github.com/librenms/librenms/pull/57))
 - Stop print-syslog.inc.php from shortening hostnames ([PR62](https://github.com/librenms/librenms/pull/62))
 - Moved some variables from defaults.inc.php to definitions.inc.php ([PR66](https://github.com/librenms/librenms/pull/66))
 - Fixed title being set correctly ([PR73](https://github.com/librenms/librenms/pull/73))
 - Added documentation to enable billing module ([PR74](https://github.com/librenms/librenms/pull/74))

####Improvements
 - Deleting devices now asks for confirmation ([PR53](https://github.com/librenms/librenms/pull/53))
 - Added ARP discovered device name and IP to eventlog ([PR54](https://github.com/librenms/librenms/pull/54))
 - Initial updated design release ([PR59](https://github.com/librenms/librenms/pull/59))
 - Added ifAlias script ([PR70](https://github.com/librenms/librenms/pull/70))
 - Added console ui ([PR72](https://github.com/librenms/librenms/pull/72))
