/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.RotateHandle;
import org.jhotdraw.draw.TransformRestoreEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class TransformHandleKit {
    public static void addCornerTransformHandles(Figure figure, Collection<Handle> collection) {
        collection.add(TransformHandleKit.southEast(figure));
        collection.add(TransformHandleKit.southWest(figure));
        collection.add(TransformHandleKit.northEast(figure));
        collection.add(TransformHandleKit.northWest(figure));
    }

    public static void addEdgeTransformHandles(Figure figure, Collection<Handle> collection) {
        collection.add(TransformHandleKit.south(figure));
        collection.add(TransformHandleKit.north(figure));
        collection.add(TransformHandleKit.east(figure));
        collection.add(TransformHandleKit.west(figure));
    }

    public static void addScaleMoveTransformHandles(Figure figure, Collection<Handle> collection) {
        TransformHandleKit.addCornerTransformHandles(figure, collection);
        TransformHandleKit.addEdgeTransformHandles(figure, collection);
    }

    public static void addTransformHandles(Figure figure, Collection<Handle> collection) {
        collection.add(new BoundsOutlineHandle(figure, true, false));
        TransformHandleKit.addCornerTransformHandles(figure, collection);
        TransformHandleKit.addEdgeTransformHandles(figure, collection);
        collection.add(new RotateHandle(figure));
    }

    public static void addGroupTransformHandles(Figure figure, Collection<Handle> collection) {
        collection.add(new BoundsOutlineHandle(figure, HandleAttributeKeys.GROUP_BOUNDS_STROKE_1, HandleAttributeKeys.GROUP_BOUNDS_COLOR_1, HandleAttributeKeys.GROUP_BOUNDS_STROKE_2, HandleAttributeKeys.GROUP_BOUNDS_COLOR_2, HandleAttributeKeys.GROUP_BOUNDS_STROKE_1_DISABLED, HandleAttributeKeys.GROUP_BOUNDS_COLOR_1_DISABLED, HandleAttributeKeys.GROUP_BOUNDS_STROKE_2_DISABLED, HandleAttributeKeys.GROUP_BOUNDS_COLOR_2_DISABLED));
        TransformHandleKit.addCornerTransformHandles(figure, collection);
        TransformHandleKit.addEdgeTransformHandles(figure, collection);
        collection.add(new RotateHandle(figure));
    }

    public static void addGroupHoverHandles(Figure figure, Collection<Handle> collection) {
        collection.add(new BoundsOutlineHandle(figure, HandleAttributeKeys.GROUP_BOUNDS_STROKE_1_HOVER, HandleAttributeKeys.GROUP_BOUNDS_COLOR_1_HOVER, HandleAttributeKeys.GROUP_BOUNDS_STROKE_2_HOVER, HandleAttributeKeys.GROUP_BOUNDS_COLOR_2_HOVER, HandleAttributeKeys.GROUP_BOUNDS_STROKE_1_DISABLED, HandleAttributeKeys.GROUP_BOUNDS_COLOR_1_DISABLED, HandleAttributeKeys.GROUP_BOUNDS_STROKE_2_DISABLED, HandleAttributeKeys.GROUP_BOUNDS_COLOR_2_DISABLED));
    }

    public static Handle south(Figure figure) {
        return new SouthHandle(figure);
    }

    public static Handle southEast(Figure figure) {
        return new SouthEastHandle(figure);
    }

    public static Handle southWest(Figure figure) {
        return new SouthWestHandle(figure);
    }

    public static Handle north(Figure figure) {
        return new NorthHandle(figure);
    }

    public static Handle northEast(Figure figure) {
        return new NorthEastHandle(figure);
    }

    public static Handle northWest(Figure figure) {
        return new NorthWestHandle(figure);
    }

    public static Handle east(Figure figure) {
        return new EastHandle(figure);
    }

    public static Handle west(Figure figure) {
        return new WestHandle(figure);
    }

    private static class EastHandle
    extends TransformHandle {
        EastHandle(Figure figure) {
            super(figure, RelativeLocator.east());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getTransformedBounds();
            this.transform(new Point2D.Double(double_2.x, double_2.y), new Point2D.Double(Math.max(double_2.x + 1.0, double_.x), double_2.y + double_2.height));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Object object = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double double_ = this.getTransformedBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    if (double_.width > 1.0) {
                        this.transform(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width - 1.0, double_.y + double_.height));
                    }
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    this.transform(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width + 1.0, double_.y + double_.height));
                    keyEvent.consume();
                }
            }
            this.fireUndoableEditHappened(new TransformRestoreEdit(this.getOwner(), object, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(11);
        }
    }

    private static class NorthEastHandle
    extends TransformHandle {
        NorthEastHandle(Figure figure) {
            super(figure, RelativeLocator.northEast());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getTransformedBounds();
            this.transform(new Point2D.Double(double_2.x, Math.min(double_2.y + double_2.height - 1.0, double_.y)), new Point2D.Double(Math.max(double_2.x, double_.x), double_2.y + double_2.height));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Object object = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double double_ = this.getTransformedBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.transform(new Point2D.Double(double_.x, double_.y - 1.0), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    if (double_.height > 1.0) {
                        this.transform(new Point2D.Double(double_.x, double_.y + 1.0), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    }
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    if (double_.width > 1.0) {
                        this.transform(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width - 1.0, double_.y + double_.height));
                    }
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    this.transform(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width + 1.0, double_.y + double_.height));
                    keyEvent.consume();
                }
            }
            this.fireUndoableEditHappened(new TransformRestoreEdit(this.getOwner(), object, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(7);
        }
    }

    private static class NorthHandle
    extends TransformHandle {
        NorthHandle(Figure figure) {
            super(figure, RelativeLocator.north());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getTransformedBounds();
            this.transform(new Point2D.Double(double_2.x, Math.min(double_2.y + double_2.height - 1.0, double_.y)), new Point2D.Double(double_2.x + double_2.width, double_2.y + double_2.height));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Object object = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double double_ = this.getTransformedBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.transform(new Point2D.Double(double_.x, double_.y - 1.0), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    if (double_.height > 1.0) {
                        this.transform(new Point2D.Double(double_.x, double_.y + 1.0), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    }
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    keyEvent.consume();
                }
            }
            this.fireUndoableEditHappened(new TransformRestoreEdit(this.getOwner(), object, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(8);
        }
    }

    private static class NorthWestHandle
    extends TransformHandle {
        NorthWestHandle(Figure figure) {
            super(figure, RelativeLocator.northWest());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getTransformedBounds();
            this.transform(new Point2D.Double(Math.min(double_2.x + double_2.width - 1.0, double_.x), Math.min(double_2.y + double_2.height - 1.0, double_.y)), new Point2D.Double(double_2.x + double_2.width, double_2.y + double_2.height));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Object object = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double double_ = this.getTransformedBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.transform(new Point2D.Double(double_.x, double_.y - 1.0), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    if (double_.height > 1.0) {
                        this.transform(new Point2D.Double(double_.x, double_.y + 1.0), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    }
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    this.transform(new Point2D.Double(double_.x - 1.0, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    if (double_.width > 1.0) {
                        this.transform(new Point2D.Double(double_.x + 1.0, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    }
                    keyEvent.consume();
                }
            }
            this.fireUndoableEditHappened(new TransformRestoreEdit(this.getOwner(), object, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(6);
        }
    }

    private static class SouthEastHandle
    extends TransformHandle {
        SouthEastHandle(Figure figure) {
            super(figure, RelativeLocator.southEast());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getTransformedBounds();
            this.transform(new Point2D.Double(double_2.x, double_2.y), new Point2D.Double(Math.max(double_2.x + 1.0, double_.x), Math.max(double_2.y + 1.0, double_.y)));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Object object = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double double_ = this.getTransformedBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    if (double_.height > 1.0) {
                        this.transform(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height - 1.0));
                    }
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    this.transform(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height + 1.0));
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    if (double_.width > 1.0) {
                        this.transform(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width - 1.0, double_.y + double_.height));
                    }
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    this.transform(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width + 1.0, double_.y + double_.height));
                    keyEvent.consume();
                }
            }
            this.fireUndoableEditHappened(new TransformRestoreEdit(this.getOwner(), object, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(5);
        }
    }

    private static class SouthHandle
    extends TransformHandle {
        SouthHandle(Figure figure) {
            super(figure, RelativeLocator.south());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getTransformedBounds();
            this.transform(new Point2D.Double(double_2.x, double_2.y), new Point2D.Double(double_2.x + double_2.width, Math.max(double_2.y + 1.0, double_.y)));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Object object = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double double_ = this.getTransformedBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    if (double_.height > 1.0) {
                        this.transform(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height - 1.0));
                    }
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    this.transform(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height + 1.0));
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    keyEvent.consume();
                }
            }
            this.fireUndoableEditHappened(new TransformRestoreEdit(this.getOwner(), object, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(9);
        }
    }

    private static class SouthWestHandle
    extends TransformHandle {
        SouthWestHandle(Figure figure) {
            super(figure, RelativeLocator.southWest());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getTransformedBounds();
            this.transform(new Point2D.Double(Math.min(double_2.x + double_2.width - 1.0, double_.x), double_2.y), new Point2D.Double(double_2.x + double_2.width, Math.max(double_2.y + 1.0, double_.y)));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Object object = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double double_ = this.getTransformedBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    if (double_.height > 1.0) {
                        this.transform(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height - 1.0));
                    }
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    this.transform(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height + 1.0));
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    this.transform(new Point2D.Double(double_.x - 1.0, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    if (double_.width > 1.0) {
                        this.transform(new Point2D.Double(double_.x + 1.0, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    }
                    keyEvent.consume();
                }
            }
            this.fireUndoableEditHappened(new TransformRestoreEdit(this.getOwner(), object, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(4);
        }
    }

    private static class TransformHandle
    extends LocatorHandle {
        private int dx;
        private int dy;
        private Object geometry;

        TransformHandle(Figure figure, Locator locator) {
            super(figure, locator);
        }

        @Override
        public String getToolTipText(Point point) {
            ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            return resourceBundleUtil.getString("handle.transform.toolTipText");
        }

        @Override
        public void draw(Graphics2D graphics2D) {
            if (this.getEditor().getTool().supportsHandleInteraction()) {
                this.drawDiamond(graphics2D, this.getEditor().getHandleAttribute(HandleAttributeKeys.TRANSFORM_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.TRANSFORM_HANDLE_STROKE_COLOR));
            } else {
                this.drawDiamond(graphics2D, this.getEditor().getHandleAttribute(HandleAttributeKeys.TRANSFORM_HANDLE_FILL_COLOR_DISABLED), this.getEditor().getHandleAttribute(HandleAttributeKeys.TRANSFORM_HANDLE_STROKE_COLOR_DISABLED));
            }
        }

        protected void drawArc(Graphics2D graphics2D) {
            Point point = this.getLocation();
            graphics2D.drawArc(point.x, point.y, 6, 6, 0, 180);
        }

        protected Rectangle2D.Double getTransformedBounds() {
            Figure figure = this.getOwner();
            Rectangle2D.Double double_ = figure.getBounds();
            if (figure.get(AttributeKeys.TRANSFORM) != null) {
                Rectangle2D rectangle2D = figure.get(AttributeKeys.TRANSFORM).createTransformedShape(double_).getBounds2D();
                double_.x = rectangle2D.getX();
                double_.y = rectangle2D.getY();
                double_.width = rectangle2D.getWidth();
                double_.height = rectangle2D.getHeight();
            }
            return double_;
        }

        @Override
        public void trackStart(Point point, int n) {
            this.geometry = this.getOwner().getTransformRestoreData();
            Point point2 = this.getLocation();
            this.dx = -point.x + point2.x;
            this.dy = -point.y + point2.y;
        }

        @Override
        public void trackStep(Point point, Point point2, int n) {
            Point2D.Double double_ = this.view.viewToDrawing(new Point(point2.x + this.dx, point2.y + this.dy));
            this.view.getConstrainer().constrainPoint(double_);
            this.trackStepNormalized(double_);
        }

        @Override
        public void trackEnd(Point point, Point point2, int n) {
            this.fireUndoableEditHappened(new TransformRestoreEdit(this.getOwner(), this.geometry, this.getOwner().getTransformRestoreData()));
        }

        protected void trackStepNormalized(Point2D.Double double_) {
        }

        protected void transform(Point2D.Double double_, Point2D.Double double_2) {
            Figure figure = this.getOwner();
            figure.willChange();
            Rectangle2D.Double double_3 = this.getTransformedBounds();
            Rectangle2D.Double double_4 = new Rectangle2D.Double(Math.min(double_.x, double_2.x), Math.min(double_.y, double_2.y), Math.abs(double_.x - double_2.x), Math.abs(double_.y - double_2.y));
            double d = double_4.width / double_3.width;
            double d2 = double_4.height / double_3.height;
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(-double_3.x, -double_3.y);
            if (!(Double.isNaN(d) || Double.isNaN(d2) || d == 1.0 && d2 == 1.0 || d < 1.0E-4 || d2 < 1.0E-4)) {
                figure.transform(affineTransform);
                affineTransform.setToIdentity();
                affineTransform.scale(d, d2);
                figure.transform(affineTransform);
                affineTransform.setToIdentity();
            }
            affineTransform.translate(double_4.x, double_4.y);
            figure.transform(affineTransform);
            figure.changed();
        }
    }

    private static class WestHandle
    extends TransformHandle {
        WestHandle(Figure figure) {
            super(figure, RelativeLocator.west());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getTransformedBounds();
            this.transform(new Point2D.Double(Math.min(double_2.x + double_2.width - 1.0, double_.x), double_2.y), new Point2D.Double(double_2.x + double_2.width, double_2.y + double_2.height));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Object object = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double double_ = this.getTransformedBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    this.transform(new Point2D.Double(double_.x - 1.0, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    if (double_.width > 1.0) {
                        this.transform(new Point2D.Double(double_.x + 1.0, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    }
                    keyEvent.consume();
                }
            }
            this.fireUndoableEditHappened(new TransformRestoreEdit(this.getOwner(), object, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(10);
        }
    }
}

