/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.dexer;

import com.android.dx.cf.code.SimException;
import com.android.dx.cf.direct.ClassPathOpener;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.command.DxConsole;
import com.android.dx.command.UsageException;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.cf.CodeStatistics;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.EncodedMethod;
import com.android.dx.io.DexBuffer;
import com.android.dx.merge.CollisionPolicy;
import com.android.dx.merge.DexMerger;
import com.android.dx.rop.annotation.Annotation;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.rop.annotation.AnnotationsList;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import com.android.dx.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class Main {
    private static final String IN_RE_CORE_CLASSES = "Ill-advised or mistaken usage of a core class (java.* or javax.*)\nwhen not building a core library.\n\nThis is often due to inadvertently including a core library file\nin your application's project, when using an IDE (such as\nEclipse). If you are sure you're not intentionally defining a\ncore class, then this is the most likely explanation of what's\ngoing on.\n\nHowever, you might actually be trying to define a class in a core\nnamespace, the source of which you may have taken, for example,\nfrom a non-Android virtual machine project. This will most\nassuredly not work. At a minimum, it jeopardizes the\ncompatibility of your app with future versions of the platform.\nIt is also often of questionable legality.\n\nIf you really intend to build a core library -- which is only\nappropriate as part of creating a full virtual machine\ndistribution, as opposed to compiling an application -- then use\nthe \"--core-library\" option to suppress this error message.\n\nIf you go ahead and use \"--core-library\" but are in fact\nbuilding an application, then be forewarned that your application\nwill still fail to build or run, at some point. Please be\nprepared for angry customers who find, for example, that your\napplication ceases to function once they upgrade their operating\nsystem. You will be to blame for this problem.\n\nIf you are legitimately using some code that happens to be in a\ncore package, then the easiest safe alternative you have is to\nrepackage that code. That is, move the classes in question into\nyour own package namespace. This means that they will never be in\nconflict with core system classes. JarJar is a tool that may help\nyou in this endeavor. If you find that you cannot do this, then\nthat is an indication that the path you are on will ultimately\nlead to pain, suffering, grief, and lamentation.\n";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
    private static final String[] JAVAX_CORE = new String[]{"accessibility", "crypto", "imageio", "management", "naming", "net", "print", "rmi", "security", "sip", "sound", "sql", "swing", "transaction", "xml"};
    private static int warnings = 0;
    private static int errors = 0;
    private static Arguments args;
    private static DexFile outputDex;
    private static TreeMap<String, byte[]> outputResources;
    private static final List<byte[]> libraryDexBuffers;
    private static ExecutorService threadPool;
    private static boolean anyFilesProcessed;
    private static long minimumFileAge;

    private Main() {
    }

    public static void main(String[] argArray) throws IOException {
        Arguments arguments = new Arguments();
        arguments.parse(argArray);
        int result = Main.run(arguments);
        if (result != 0) {
            System.exit(result);
        }
    }

    public static int run(Arguments arguments) throws IOException {
        warnings = 0;
        errors = 0;
        args = arguments;
        Main.args.makeOptionsObjects();
        File incrementalOutFile = null;
        if (Main.args.incremental) {
            if (Main.args.outName == null) {
                System.err.println("error: no incremental output name specified");
                return -1;
            }
            incrementalOutFile = new File(Main.args.outName);
            if (incrementalOutFile.exists()) {
                minimumFileAge = incrementalOutFile.lastModified();
            }
        }
        if (!Main.processAllFiles()) {
            return 1;
        }
        if (Main.args.incremental && !anyFilesProcessed) {
            return 0;
        }
        byte[] outArray = null;
        if (!outputDex.isEmpty() && (outArray = Main.writeDex()) == null) {
            return 2;
        }
        if (Main.args.incremental) {
            outArray = Main.mergeIncremental(outArray, incrementalOutFile);
        }
        outArray = Main.mergeLibraryDexBuffers(outArray);
        if (Main.args.jarOutput) {
            outputDex = null;
            if (!Main.createJar(Main.args.outName, outArray)) {
                return 3;
            }
        } else if (outArray != null && Main.args.outName != null) {
            OutputStream out = Main.openOutput(Main.args.outName);
            out.write(outArray);
            Main.closeOutput(out);
        }
        return 0;
    }

    private static byte[] mergeIncremental(byte[] update, File base) throws IOException {
        DexBuffer dexA = null;
        DexBuffer dexB = null;
        if (update != null) {
            dexA = new DexBuffer(update);
        }
        if (base.exists()) {
            dexB = new DexBuffer(base);
        }
        if (dexA == null && dexB == null) {
            return null;
        }
        DexBuffer result = dexA == null ? dexB : (dexB == null ? dexA : new DexMerger(dexA, dexB, CollisionPolicy.KEEP_FIRST).merge());
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        result.writeTo(bytesOut);
        return bytesOut.toByteArray();
    }

    private static byte[] mergeLibraryDexBuffers(byte[] outArray) throws IOException {
        for (byte[] libraryDexBuffer : libraryDexBuffers) {
            if (outArray == null) {
                outArray = libraryDexBuffer;
                continue;
            }
            DexBuffer a = new DexBuffer(outArray);
            DexBuffer b = new DexBuffer(libraryDexBuffer);
            DexBuffer ab = new DexMerger(a, b, CollisionPolicy.FAIL).merge();
            outArray = ab.getBytes();
        }
        return outArray;
    }

    private static boolean processAllFiles() {
        outputDex = new DexFile(Main.args.dexOptions);
        if (Main.args.jarOutput) {
            outputResources = new TreeMap();
        }
        if (Main.args.dumpWidth != 0) {
            outputDex.setDumpWidth(Main.args.dumpWidth);
        }
        anyFilesProcessed = false;
        String[] fileNames = Main.args.fileNames;
        if (Main.args.numThreads > 1) {
            threadPool = Executors.newFixedThreadPool(Main.args.numThreads);
        }
        try {
            for (int i = 0; i < fileNames.length; ++i) {
                if (!Main.processOne(fileNames[i])) continue;
                anyFilesProcessed = true;
            }
        }
        catch (StopProcessing ex) {
            // empty catch block
        }
        if (Main.args.numThreads > 1) {
            try {
                threadPool.shutdown();
                threadPool.awaitTermination(600L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Timed out waiting for threads.");
            }
        }
        if (warnings != 0) {
            DxConsole.err.println(warnings + " warning" + (warnings == 1 ? "" : "s"));
        }
        if (errors != 0) {
            DxConsole.err.println(errors + " error" + (errors == 1 ? "" : "s") + "; aborting");
            return false;
        }
        if (Main.args.incremental && !anyFilesProcessed) {
            return true;
        }
        if (!anyFilesProcessed && !Main.args.emptyOk) {
            DxConsole.err.println("no classfiles specified");
            return false;
        }
        if (Main.args.optimize && Main.args.statistics) {
            CodeStatistics.dumpStatistics(DxConsole.out);
        }
        return true;
    }

    private static boolean processOne(String pathname) {
        ClassPathOpener opener = new ClassPathOpener(pathname, false, new ClassPathOpener.Consumer(){

            public boolean processFileBytes(String name, long lastModified, byte[] bytes) {
                if (args.numThreads > 1) {
                    threadPool.execute(new ParallelProcessor(name, lastModified, bytes));
                    return false;
                }
                return Main.processFileBytes(name, lastModified, bytes);
            }

            public void onException(Exception ex) {
                if (ex instanceof StopProcessing) {
                    throw (StopProcessing)ex;
                }
                if (ex instanceof SimException) {
                    DxConsole.err.println("\nEXCEPTION FROM SIMULATION:");
                    DxConsole.err.println(ex.getMessage() + "\n");
                    DxConsole.err.println(((SimException)ex).getContext());
                } else {
                    DxConsole.err.println("\nUNEXPECTED TOP-LEVEL EXCEPTION:");
                    ex.printStackTrace(DxConsole.err);
                }
                errors++;
            }

            public void onProcessArchiveStart(File file) {
                if (args.verbose) {
                    DxConsole.out.println("processing archive " + file + "...");
                }
            }
        });
        return opener.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processFileBytes(String name, long lastModified, byte[] bytes) {
        boolean keepResources;
        boolean isClass = name.endsWith(".class");
        boolean isClassesDex = name.equals("classes.dex");
        boolean bl = keepResources = outputResources != null;
        if (!(isClass || isClassesDex || keepResources)) {
            if (Main.args.verbose) {
                DxConsole.out.println("ignored resource " + name);
            }
            return false;
        }
        if (Main.args.verbose) {
            DxConsole.out.println("processing " + name + "...");
        }
        String fixedName = Main.fixPath(name);
        if (isClass) {
            if (keepResources && Main.args.keepClassesInJar) {
                TreeMap<String, byte[]> treeMap = outputResources;
                synchronized (treeMap) {
                    outputResources.put(fixedName, bytes);
                }
            }
            if (lastModified < minimumFileAge) {
                return true;
            }
            return Main.processClass(fixedName, bytes);
        }
        if (isClassesDex) {
            List<byte[]> list = libraryDexBuffers;
            synchronized (list) {
                libraryDexBuffers.add(bytes);
            }
            return true;
        }
        TreeMap<String, byte[]> treeMap = outputResources;
        synchronized (treeMap) {
            outputResources.put(fixedName, bytes);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processClass(String name, byte[] bytes) {
        if (!Main.args.coreLibrary) {
            Main.checkClassName(name);
        }
        try {
            ClassDefItem clazz = CfTranslator.translate(name, bytes, Main.args.cfOptions, Main.args.dexOptions);
            DexFile dexFile = outputDex;
            synchronized (dexFile) {
                outputDex.add(clazz);
            }
            return true;
        }
        catch (ParseException ex) {
            DxConsole.err.println("\ntrouble processing:");
            if (Main.args.debug) {
                ex.printStackTrace(DxConsole.err);
            } else {
                ex.printContext(DxConsole.err);
            }
            ++warnings;
            return false;
        }
    }

    private static void checkClassName(String name) {
        boolean bogus = false;
        if (name.startsWith("java/")) {
            bogus = true;
        } else if (name.startsWith("javax/")) {
            int slashAt = name.indexOf(47, 6);
            if (slashAt == -1) {
                bogus = true;
            } else {
                String pkg = name.substring(6, slashAt);
                boolean bl = bogus = Arrays.binarySearch(JAVAX_CORE, pkg) >= 0;
            }
        }
        if (!bogus) {
            return;
        }
        DxConsole.err.println("\ntrouble processing \"" + name + "\":\n\n" + IN_RE_CORE_CLASSES);
        ++errors;
        throw new StopProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] writeDex() {
        byte[] outArray = null;
        try {
            OutputStream humanOutRaw;
            block11: {
                humanOutRaw = null;
                OutputStreamWriter humanOut = null;
                try {
                    if (Main.args.humanOutName != null) {
                        humanOutRaw = Main.openOutput(Main.args.humanOutName);
                        humanOut = new OutputStreamWriter(humanOutRaw);
                    }
                    if (Main.args.methodToDump != null) {
                        outputDex.toDex(null, false);
                        Main.dumpMethod(outputDex, Main.args.methodToDump, humanOut);
                    } else {
                        outArray = outputDex.toDex(humanOut, Main.args.verboseDump);
                    }
                    if (Main.args.statistics) {
                        DxConsole.out.println(outputDex.getStatistics().toHuman());
                    }
                    if (humanOut == null) break block11;
                }
                catch (Throwable throwable) {
                    if (humanOut != null) {
                        humanOut.flush();
                    }
                    Main.closeOutput(humanOutRaw);
                    throw throwable;
                }
                humanOut.flush();
            }
            Main.closeOutput(humanOutRaw);
        }
        catch (Exception ex) {
            if (Main.args.debug) {
                DxConsole.err.println("\ntrouble writing output:");
                ex.printStackTrace(DxConsole.err);
            } else {
                DxConsole.err.println("\ntrouble writing output: " + ex.getMessage());
            }
            return null;
        }
        return outArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createJar(String fileName, byte[] dexArray) {
        try {
            Manifest manifest = Main.makeManifest();
            OutputStream out = Main.openOutput(fileName);
            JarOutputStream jarOut = new JarOutputStream(out, manifest);
            if (dexArray != null) {
                outputResources.put("classes.dex", dexArray);
            }
            try {
                for (Map.Entry<String, byte[]> e : outputResources.entrySet()) {
                    String name = e.getKey();
                    byte[] contents = e.getValue();
                    JarEntry entry = new JarEntry(name);
                    if (Main.args.verbose) {
                        DxConsole.out.println("writing " + name + "; size " + contents.length + "...");
                    }
                    entry.setSize(contents.length);
                    jarOut.putNextEntry(entry);
                    jarOut.write(contents);
                    jarOut.closeEntry();
                }
            }
            finally {
                jarOut.finish();
                jarOut.flush();
                Main.closeOutput(out);
            }
        }
        catch (Exception ex) {
            if (Main.args.debug) {
                DxConsole.err.println("\ntrouble writing output:");
                ex.printStackTrace(DxConsole.err);
            } else {
                DxConsole.err.println("\ntrouble writing output: " + ex.getMessage());
            }
            return false;
        }
        return true;
    }

    private static Manifest makeManifest() throws IOException {
        Attributes attribs;
        Manifest manifest;
        byte[] manifestBytes = outputResources.get(MANIFEST_NAME);
        if (manifestBytes == null) {
            manifest = new Manifest();
            attribs = manifest.getMainAttributes();
            attribs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        } else {
            manifest = new Manifest(new ByteArrayInputStream(manifestBytes));
            attribs = manifest.getMainAttributes();
            outputResources.remove(MANIFEST_NAME);
        }
        String createdBy = attribs.getValue(CREATED_BY);
        createdBy = createdBy == null ? "" : createdBy + " + ";
        createdBy = createdBy + "dx 1.7";
        attribs.put(CREATED_BY, createdBy);
        attribs.putValue("Dex-Location", "classes.dex");
        return manifest;
    }

    private static OutputStream openOutput(String name) throws IOException {
        if (name.equals("-") || name.startsWith("-.")) {
            return System.out;
        }
        return new FileOutputStream(name);
    }

    private static void closeOutput(OutputStream stream) throws IOException {
        if (stream == null) {
            return;
        }
        stream.flush();
        if (stream != System.out) {
            stream.close();
        }
    }

    private static String fixPath(String path) {
        int index;
        if (File.separatorChar == '\\') {
            path = path.replace('\\', '/');
        }
        if ((index = path.lastIndexOf("/./")) != -1) {
            return path.substring(index + 3);
        }
        if (path.startsWith("./")) {
            return path.substring(2);
        }
        return path;
    }

    private static void dumpMethod(DexFile dex, String fqName, OutputStreamWriter out) {
        boolean wildcard = fqName.endsWith("*");
        int lastDot = fqName.lastIndexOf(46);
        if (lastDot <= 0 || lastDot == fqName.length() - 1) {
            DxConsole.err.println("bogus fully-qualified method name: " + fqName);
            return;
        }
        String className = fqName.substring(0, lastDot).replace('.', '/');
        String methodName = fqName.substring(lastDot + 1);
        ClassDefItem clazz = dex.getClassOrNull(className);
        if (clazz == null) {
            DxConsole.err.println("no such class: " + className);
            return;
        }
        if (wildcard) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        ArrayList<EncodedMethod> allMeths = clazz.getMethods();
        TreeMap<CstNat, EncodedMethod> meths = new TreeMap<CstNat, EncodedMethod>();
        for (EncodedMethod meth : allMeths) {
            String methName = meth.getName().getString();
            if ((!wildcard || !methName.startsWith(methodName)) && (wildcard || !methName.equals(methodName))) continue;
            meths.put(meth.getRef().getNat(), meth);
        }
        if (meths.size() == 0) {
            DxConsole.err.println("no such method: " + fqName);
            return;
        }
        PrintWriter pw = new PrintWriter(out);
        for (EncodedMethod meth : meths.values()) {
            meth.debugPrint(pw, Main.args.verboseDump);
            CstString sourceFile = clazz.getSourceFile();
            if (sourceFile != null) {
                pw.println("  source file: " + sourceFile.toQuoted());
            }
            Annotations methodAnnotations = clazz.getMethodAnnotations(meth.getRef());
            AnnotationsList parameterAnnotations = clazz.getParameterAnnotations(meth.getRef());
            if (methodAnnotations != null) {
                pw.println("  method annotations:");
                for (Annotation a : methodAnnotations.getAnnotations()) {
                    pw.println("    " + a);
                }
            }
            if (parameterAnnotations == null) continue;
            pw.println("  parameter annotations:");
            int sz = parameterAnnotations.size();
            for (int i = 0; i < sz; ++i) {
                pw.println("    parameter " + i);
                Annotations annotations = parameterAnnotations.get(i);
                for (Annotation a : annotations.getAnnotations()) {
                    pw.println("      " + a);
                }
            }
        }
        pw.flush();
    }

    static {
        libraryDexBuffers = new ArrayList<byte[]>();
        minimumFileAge = 0L;
    }

    private static class ParallelProcessor
    implements Runnable {
        String path;
        long lastModified;
        byte[] bytes;

        private ParallelProcessor(String path, long lastModified, byte[] bytes) {
            this.path = path;
            this.lastModified = lastModified;
            this.bytes = bytes;
        }

        public void run() {
            if (Main.processFileBytes(this.path, this.lastModified, this.bytes)) {
                anyFilesProcessed = true;
            }
        }
    }

    public static class Arguments {
        public boolean debug = false;
        public boolean verbose = false;
        public boolean verboseDump = false;
        public boolean coreLibrary = false;
        public String methodToDump = null;
        public int dumpWidth = 0;
        public String outName = null;
        public String humanOutName = null;
        public boolean strictNameCheck = true;
        public boolean emptyOk = false;
        public boolean jarOutput = false;
        public boolean keepClassesInJar = false;
        public int targetApiLevel = 13;
        public int positionInfo = 2;
        public boolean localInfo = true;
        public boolean incremental = false;
        public String[] fileNames;
        public boolean optimize = true;
        public String optimizeListFile = null;
        public String dontOptimizeListFile = null;
        public boolean statistics;
        public CfOptions cfOptions;
        public DexOptions dexOptions;
        public int numThreads = 1;

        public void parse(String[] args) {
            ArgumentsParser parser = new ArgumentsParser(args);
            while (parser.getNext()) {
                if (parser.isArg("--debug")) {
                    this.debug = true;
                    continue;
                }
                if (parser.isArg("--verbose")) {
                    this.verbose = true;
                    continue;
                }
                if (parser.isArg("--verbose-dump")) {
                    this.verboseDump = true;
                    continue;
                }
                if (parser.isArg("--no-files")) {
                    this.emptyOk = true;
                    continue;
                }
                if (parser.isArg("--no-optimize")) {
                    this.optimize = false;
                    continue;
                }
                if (parser.isArg("--no-strict")) {
                    this.strictNameCheck = false;
                    continue;
                }
                if (parser.isArg("--core-library")) {
                    this.coreLibrary = true;
                    continue;
                }
                if (parser.isArg("--statistics")) {
                    this.statistics = true;
                    continue;
                }
                if (parser.isArg("--optimize-list=")) {
                    if (this.dontOptimizeListFile != null) {
                        System.err.println("--optimize-list and --no-optimize-list are incompatible.");
                        throw new UsageException();
                    }
                    this.optimize = true;
                    this.optimizeListFile = parser.getLastValue();
                    continue;
                }
                if (parser.isArg("--no-optimize-list=")) {
                    if (this.dontOptimizeListFile != null) {
                        System.err.println("--optimize-list and --no-optimize-list are incompatible.");
                        throw new UsageException();
                    }
                    this.optimize = true;
                    this.dontOptimizeListFile = parser.getLastValue();
                    continue;
                }
                if (parser.isArg("--keep-classes")) {
                    this.keepClassesInJar = true;
                    continue;
                }
                if (parser.isArg("--output=")) {
                    this.outName = parser.getLastValue();
                    if (FileUtils.hasArchiveSuffix(this.outName)) {
                        this.jarOutput = true;
                        continue;
                    }
                    if (this.outName.endsWith(".dex") || this.outName.equals("-")) {
                        this.jarOutput = false;
                        continue;
                    }
                    System.err.println("unknown output extension: " + this.outName);
                    throw new UsageException();
                }
                if (parser.isArg("--dump-to=")) {
                    this.humanOutName = parser.getLastValue();
                    continue;
                }
                if (parser.isArg("--dump-width=")) {
                    this.dumpWidth = Integer.parseInt(parser.getLastValue());
                    continue;
                }
                if (parser.isArg("--dump-method=")) {
                    this.methodToDump = parser.getLastValue();
                    this.jarOutput = false;
                    continue;
                }
                if (parser.isArg("--positions=")) {
                    String pstr = parser.getLastValue().intern();
                    if (pstr == "none") {
                        this.positionInfo = 1;
                        continue;
                    }
                    if (pstr == "important") {
                        this.positionInfo = 3;
                        continue;
                    }
                    if (pstr == "lines") {
                        this.positionInfo = 2;
                        continue;
                    }
                    System.err.println("unknown positions option: " + pstr);
                    throw new UsageException();
                }
                if (parser.isArg("--no-locals")) {
                    this.localInfo = false;
                    continue;
                }
                if (parser.isArg("--num-threads=")) {
                    this.numThreads = Integer.parseInt(parser.getLastValue());
                    continue;
                }
                if (parser.isArg("--incremental")) {
                    this.incremental = true;
                    continue;
                }
                System.err.println("unknown option: " + parser.getCurrent());
                throw new UsageException();
            }
            this.fileNames = parser.getRemaining();
            if (this.fileNames.length == 0) {
                if (!this.emptyOk) {
                    System.err.println("no input files specified");
                    throw new UsageException();
                }
            } else if (this.emptyOk) {
                System.out.println("ignoring input files");
            }
            if (this.humanOutName == null && this.methodToDump != null) {
                this.humanOutName = "-";
            }
            this.makeOptionsObjects();
        }

        private void makeOptionsObjects() {
            this.cfOptions = new CfOptions();
            this.cfOptions.positionInfo = this.positionInfo;
            this.cfOptions.localInfo = this.localInfo;
            this.cfOptions.strictNameCheck = this.strictNameCheck;
            this.cfOptions.optimize = this.optimize;
            this.cfOptions.optimizeListFile = this.optimizeListFile;
            this.cfOptions.dontOptimizeListFile = this.dontOptimizeListFile;
            this.cfOptions.statistics = this.statistics;
            this.cfOptions.warn = DxConsole.err;
            this.dexOptions = new DexOptions();
            this.dexOptions.targetApiLevel = this.targetApiLevel;
        }

        private static class ArgumentsParser {
            private final String[] arguments;
            private int index;
            private String current;
            private String lastValue;

            public ArgumentsParser(String[] arguments) {
                this.arguments = arguments;
                this.index = 0;
            }

            public String getCurrent() {
                return this.current;
            }

            public String getLastValue() {
                return this.lastValue;
            }

            public boolean getNext() {
                if (this.index >= this.arguments.length) {
                    return false;
                }
                this.current = this.arguments[this.index];
                if (this.current.equals("--") || !this.current.startsWith("--")) {
                    return false;
                }
                ++this.index;
                return true;
            }

            private boolean getNextValue() {
                if (this.index >= this.arguments.length) {
                    return false;
                }
                this.current = this.arguments[this.index];
                ++this.index;
                return true;
            }

            public String[] getRemaining() {
                int n = this.arguments.length - this.index;
                String[] remaining = new String[n];
                if (n > 0) {
                    System.arraycopy(this.arguments, this.index, remaining, 0, n);
                }
                return remaining;
            }

            public boolean isArg(String prefix) {
                int n = prefix.length();
                if (n > 0 && prefix.charAt(n - 1) == '=') {
                    if (this.current.startsWith(prefix)) {
                        this.lastValue = this.current.substring(n);
                        return true;
                    }
                    if (this.current.equals(prefix = prefix.substring(0, n - 1))) {
                        if (this.getNextValue()) {
                            this.lastValue = this.current;
                            return true;
                        }
                        System.err.println("Missing value after parameter " + prefix);
                        throw new UsageException();
                    }
                    return false;
                }
                return this.current.equals(prefix);
            }
        }
    }

    private static class StopProcessing
    extends RuntimeException {
        private StopProcessing() {
        }
    }
}

