/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.dark;

import java.awt.Color;
import java.awt.image.RGBImageFilter;

public class DarkIconFilter
extends RGBImageFilter {
    private static final float DARK_ICON_BRIGHTEN = 0.1f;

    @Override
    public int filterRGB(int n, int n2, int n3) {
        int n4 = n3 & 0xFF000000;
        int[] nArray = this.decode(n3);
        int[] nArray2 = this.invert(nArray);
        int[] nArray3 = this.invertHueBrighten(nArray2, 0.1f);
        return n4 | this.encode(nArray3);
    }

    private int[] invert(int[] nArray) {
        return new int[]{255 - nArray[0], 255 - nArray[1], 255 - nArray[2]};
    }

    private int[] invertHueBrighten(int[] nArray, float f) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(nArray[0], nArray[1], nArray[2], fArray);
        return this.decode(Color.HSBtoRGB(fArray[0] > 0.5f ? fArray[0] - 0.5f : fArray[0] + 0.5f, fArray[1], fArray[2] + (1.0f - fArray[2]) * f));
    }

    private int[] decode(int n) {
        return new int[]{(n & 0xFF0000) >> 16, (n & 0xFF00) >> 8, n & 0xFF};
    }

    private int encode(int[] nArray) {
        return this.toBoundaries(nArray[0]) << 16 | this.toBoundaries(nArray[1]) << 8 | this.toBoundaries(nArray[2]);
    }

    private int toBoundaries(int n) {
        return Math.max(0, Math.min(255, n));
    }
}

