/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import liquibase.ChecksumVersion;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.SupportsMethodValidationLevelsEnum;
import liquibase.change.Change;
import liquibase.change.ChangeMetaData;
import liquibase.change.ChangeParameterMetaData;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.plugin.AbstractPluginFactory;
import liquibase.util.LiquibaseUtil;
import lombok.Generated;

public class ChangeFactory
extends AbstractPluginFactory<Change> {
    public static final String NO_EXCEPTION_ON_UNSUPPORTED_CHANGE_TYPE = "noExceptionOnUnsupportedChangeType";
    private final Map<String, ChangeMetaData> cachedMetadata = new ConcurrentHashMap<String, ChangeMetaData>();
    private boolean performSupportsDatabaseValidation = true;
    protected static final String SUPPORTS_METHOD_REQUIRED_MESSAGE = "%s class does not implement the 'supports(Database)' method and may incorrectly override other databases changes causing unexpected behavior. Please report this to the Liquibase developers or if you are developing this change please fix it ;)";

    private ChangeFactory() {
    }

    @Override
    protected Class<Change> getPluginClass() {
        return Change.class;
    }

    @Override
    protected int getPriority(Change obj, Object ... args) {
        String commandName = (String)args[0];
        ChangeMetaData changeMetaData = this.getChangeMetaData(obj);
        if (commandName.equals(changeMetaData.getName())) {
            return changeMetaData.getPriority();
        }
        return -1;
    }

    public ChangeMetaData getChangeMetaData(String change) {
        Change changeObj = this.create(change);
        if (changeObj == null) {
            return null;
        }
        return this.getChangeMetaData(changeObj);
    }

    public ChangeMetaData getChangeMetaData(Change change) {
        String cacheKey = this.generateCacheKey(change);
        this.cachedMetadata.computeIfAbsent(cacheKey, c -> change.createChangeMetaData());
        return this.cachedMetadata.get(cacheKey);
    }

    private String generateCacheKey(Change change) {
        Object key;
        try {
            ChecksumVersion version = Scope.getCurrentScope().getChecksumVersion();
            if (version == null) {
                throw new NullPointerException();
            }
            key = change.getClass().getName() + String.valueOf((Object)version);
        }
        catch (Exception ignored) {
            key = change.getClass().getName();
        }
        return key;
    }

    public void unregister(String name) {
        for (Change change : new ArrayList(this.findAllInstances())) {
            if (!this.getChangeMetaData(change).getName().equals(name)) continue;
            this.removeInstance(change);
        }
    }

    public SortedSet<String> getDefinedChanges() {
        TreeSet<String> names = new TreeSet<String>();
        for (Change change : this.findAllInstances()) {
            names.add(this.getChangeMetaData(change).getName());
        }
        return Collections.unmodifiableSortedSet(names);
    }

    public Change create(String name) {
        Set<Change> plugins = this.getPlugins(name);
        if (plugins.isEmpty()) {
            return null;
        }
        if (plugins.size() > 1) {
            this.verifySupportsMethodImplementation(plugins);
            Database database = Scope.getCurrentScope().getDatabase();
            if (database != null && this.performSupportsDatabaseValidation) {
                plugins.removeIf(a -> !a.supports(database));
                if (plugins.isEmpty()) {
                    if (!ChangeFactory.isNoExceptionOnUnsupportedChangeType()) {
                        throw new UnexpectedLiquibaseException(String.format("No registered %s plugin found for %s database", name, database.getDisplayName()));
                    }
                    return null;
                }
            }
        }
        try {
            return (Change)plugins.iterator().next().getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public static boolean isNoExceptionOnUnsupportedChangeType() {
        return Scope.getCurrentScope().has(NO_EXCEPTION_ON_UNSUPPORTED_CHANGE_TYPE) && (Boolean)((Object)Scope.getCurrentScope().get(NO_EXCEPTION_ON_UNSUPPORTED_CHANGE_TYPE, Boolean.class)) != false;
    }

    private void verifySupportsMethodImplementation(Set<Change> plugins) {
        if (GlobalConfiguration.SUPPORTS_METHOD_VALIDATION_LEVEL.getCurrentValue().equals((Object)SupportsMethodValidationLevelsEnum.OFF)) {
            return;
        }
        for (Change plugin : plugins) {
            String packageName = plugin.getClass().getPackage().getName();
            if (packageName.startsWith("liquibase.change")) continue;
            try {
                if (!plugin.getClass().getMethod("supports", Database.class).getDeclaringClass().getPackage().getName().startsWith("liquibase.change")) continue;
                if (LiquibaseUtil.isDevVersion()) {
                    throw new UnexpectedLiquibaseException(String.format(SUPPORTS_METHOD_REQUIRED_MESSAGE, plugin.getClass().getName()));
                }
                switch (GlobalConfiguration.SUPPORTS_METHOD_VALIDATION_LEVEL.getCurrentValue()) {
                    case WARN: {
                        Scope.getCurrentScope().getLog(this.getClass()).warning(String.format(SUPPORTS_METHOD_REQUIRED_MESSAGE, plugin.getClass().getName()));
                        break;
                    }
                    case FAIL: {
                        throw new UnexpectedLiquibaseException(String.format(SUPPORTS_METHOD_REQUIRED_MESSAGE, plugin.getClass().getName()));
                    }
                }
            }
            catch (NoSuchMethodException e) {
                throw new UnexpectedLiquibaseException(String.format(SUPPORTS_METHOD_REQUIRED_MESSAGE, plugin.getClass().getName()), e);
            }
        }
    }

    public Map<String, Object> getParameters(Change change) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ChangeMetaData changeMetaData = this.getChangeMetaData(change);
        for (ChangeParameterMetaData param : changeMetaData.getParameters().values()) {
            Object currentValue = param.getCurrentValue(change);
            if (currentValue == null) continue;
            returnMap.put(param.getParameterName(), currentValue);
        }
        return returnMap;
    }

    @Deprecated
    public static ChangeFactory getInstance() {
        return Scope.getCurrentScope().getSingleton(ChangeFactory.class);
    }

    @Generated
    public void setPerformSupportsDatabaseValidation(boolean performSupportsDatabaseValidation) {
        this.performSupportsDatabaseValidation = performSupportsDatabaseValidation;
    }
}

