/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.exceptions.ParserException;
import de.rub.nds.tlsattacker.core.protocol.message.certificatestatus.CertificateStatusObject;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateStatusRequestExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.CertificateStatusGenericParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateStatusRequestExtensionParser
extends ExtensionParser<CertificateStatusRequestExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private int startOfContentPointer;

    public CertificateStatusRequestExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(CertificateStatusRequestExtensionMessage msg) {
        if ((Integer)msg.getExtensionLength().getValue() > 0) {
            this.startOfContentPointer = this.getPointer();
            try {
                LOGGER.debug("Trying to parse Certificate Status Request as regular extension.");
                msg.setCertificateStatusRequestType(this.parseIntField(1));
                LOGGER.debug("Parsed the status type " + msg.getCertificateStatusRequestType().getValue());
                msg.setResponderIDListLength(this.parseIntField(2));
                msg.setResponderIDList(this.parseByteArrayField((Integer)msg.getResponderIDListLength().getValue()));
                LOGGER.debug("Parsed the responder ID list with length " + msg.getResponderIDListLength().getValue() + " and value " + ArrayConverter.bytesToHexString((ModifiableByteArray)msg.getResponderIDList()));
                msg.setRequestExtensionLength(this.parseIntField(2));
                msg.setRequestExtension(this.parseByteArrayField((Integer)msg.getRequestExtensionLength().getValue()));
                LOGGER.debug("Parsed the request extension with length " + msg.getRequestExtensionLength().getValue() + " and value " + ArrayConverter.bytesToHexString((ModifiableByteArray)msg.getRequestExtension()));
            }
            catch (ParserException e) {
                LOGGER.debug("Certificate Status Request extension parsing failed. Trying to parse as TLS 1.3 CertificateEntry extension.");
                this.parseAsCertificateStatus(msg);
            }
            if (this.getPointer() - this.startOfContentPointer - (Integer)msg.getExtensionLength().getValue() < 0) {
                LOGGER.debug("Certificate Status Request extension parsing left some bytes over. Trying to parse as TLS 1.3 CertificateEntry extension.");
                this.parseAsCertificateStatus(msg);
            }
        }
    }

    private void parseAsCertificateStatus(CertificateStatusRequestExtensionMessage msg) {
        this.setPointer(this.startOfContentPointer);
        CertificateStatusGenericParser certificateStatusGenericParser = new CertificateStatusGenericParser(0, this.parseByteArrayField((Integer)msg.getExtensionLength().getValue()));
        CertificateStatusObject certificateStatus = certificateStatusGenericParser.parse();
        msg.setCertificateStatusType(certificateStatus.getType());
        msg.setOcspResponseLength(certificateStatus.getLength());
        msg.setOcspResponseBytes(certificateStatus.getOcspResponse());
        msg.setResponderIDListLength(null);
        msg.setRequestExtensionLength(null);
        msg.setResponderIDList((ModifiableByteArray)null);
        msg.setRequestExtension((ModifiableByteArray)null);
    }

    @Override
    protected CertificateStatusRequestExtensionMessage createExtensionMessage() {
        return new CertificateStatusRequestExtensionMessage();
    }
}

