/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * greaterThan(dvec3(-1.5lf, -1.5lf, -1.5lf), dvec3(-1.5lf, -0.5lf, 0.5lf)) => bvec3(false, false, false)
 * greaterThan(dvec3(-1.5lf, -0.5lf, -0.5lf), dvec3(1.5lf, -1.5lf, -0.5lf)) => bvec3(false, true, false)
 * greaterThan(dvec3(-0.5lf, -0.5lf, 0.5lf), dvec3(0.5lf, 1.5lf, -1.5lf)) => bvec3(false, false, true)
 * greaterThan(dvec3(0.5lf, 0.5lf, 0.5lf), dvec3(-0.5lf, 0.5lf, 1.5lf)) => bvec3(true, false, false)
 * greaterThan(dvec3(1.5lf, 1.5lf, 1.5lf), dvec3(-1.5lf, -0.5lf, 0.5lf)) => bvec3(true, true, true)
 * greaterThan(dvec3(1.5lf, -1.5lf, -1.5lf), dvec3(1.5lf, -1.5lf, -0.5lf)) => bvec3(false, false, false)
 */
#version 400

void main()
{
  double[all(equal(greaterThan(dvec3(-1.5lf, -1.5lf, -1.5lf), dvec3(-1.5lf, -0.5lf, 0.5lf)), bvec3(false, false, false))) ? 1 : -1] array0;
  double[all(equal(greaterThan(dvec3(-1.5lf, -0.5lf, -0.5lf), dvec3(1.5lf, -1.5lf, -0.5lf)), bvec3(false, true, false))) ? 1 : -1] array1;
  double[all(equal(greaterThan(dvec3(-0.5lf, -0.5lf, 0.5lf), dvec3(0.5lf, 1.5lf, -1.5lf)), bvec3(false, false, true))) ? 1 : -1] array2;
  double[all(equal(greaterThan(dvec3(0.5lf, 0.5lf, 0.5lf), dvec3(-0.5lf, 0.5lf, 1.5lf)), bvec3(true, false, false))) ? 1 : -1] array3;
  double[all(equal(greaterThan(dvec3(1.5lf, 1.5lf, 1.5lf), dvec3(-1.5lf, -0.5lf, 0.5lf)), bvec3(true, true, true))) ? 1 : -1] array4;
  double[all(equal(greaterThan(dvec3(1.5lf, -1.5lf, -1.5lf), dvec3(1.5lf, -1.5lf, -0.5lf)), bvec3(false, false, false))) ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
