/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session.connection.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.jsmpp.session.connection.Connection;
import org.jsmpp.util.StrictBufferedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(SocketConnection.class);
    private final Socket socket;
    private final InputStream in;
    private final OutputStream out;

    public SocketConnection(Socket socket) throws IOException {
        this.socket = socket;
        this.in = new StrictBufferedInputStream(socket.getInputStream(), 65536);
        this.out = socket.getOutputStream();
    }

    @Override
    public void setSoTimeout(int timeout) throws IOException {
        this.socket.setSoTimeout(timeout);
    }

    @Override
    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            logger.warn("Suppressing IOException while closing socket", (Throwable)e);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }
}

