/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.stax;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class ReceiverToXMLStreamWriter
implements Receiver {
    protected PipelineConfiguration pipe;
    protected Configuration config;
    protected String systemId;
    protected String baseURI;
    private XMLStreamWriter writer;

    public ReceiverToXMLStreamWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
        this.config = pipe.getConfiguration();
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void open() throws XPathException {
    }

    public void startDocument(int properties) throws XPathException {
        try {
            this.writer.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new XPathException(e);
        }
    }

    public void endDocument() throws XPathException {
        try {
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new XPathException(e);
        }
    }

    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    public void startElement(NodeName elemName, SchemaType typeCode, int locationId, int properties) throws XPathException {
        String local = elemName.getLocalPart();
        String uri = elemName.getURI();
        String prefix = elemName.getPrefix();
        try {
            if (prefix.equals("") && uri.equals("")) {
                this.writer.writeStartElement(local);
            } else if (prefix.equals("") && !uri.equals("")) {
                this.writer.writeStartElement(prefix, local, uri);
            } else {
                this.writer.writeStartElement(prefix, local, uri);
            }
        }
        catch (XMLStreamException e) {
            throw new XPathException(e);
        }
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        try {
            this.writer.writeNamespace(namespaceBinding.getPrefix(), namespaceBinding.getURI());
        }
        catch (XMLStreamException e) {
            throw new XPathException(e);
        }
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        String local = attName.getLocalPart();
        String uri = attName.getURI();
        String prefix = attName.getPrefix();
        try {
            if (prefix.equals("") && uri.equals("")) {
                this.writer.writeAttribute(local, value.toString());
            } else if (prefix.equals("") & !uri.equals("")) {
                this.writer.writeAttribute(uri, local, value.toString());
            } else {
                this.writer.writeAttribute(prefix, uri, local, value.toString());
            }
        }
        catch (XMLStreamException e) {
            throw new XPathException(e);
        }
    }

    public void startContent() throws XPathException {
    }

    public void endElement() throws XPathException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XPathException(e);
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        try {
            this.writer.writeCharacters(chars.toString());
        }
        catch (XMLStreamException e) {
            throw new XPathException(e);
        }
    }

    public void processingInstruction(String name, CharSequence data, int locationId, int properties) throws XPathException {
        try {
            this.writer.writeProcessingInstruction(name, data.toString());
        }
        catch (XMLStreamException e) {
            throw new XPathException(e);
        }
    }

    public void comment(CharSequence content, int locationId, int properties) throws XPathException {
        try {
            this.writer.writeComment(content.toString());
        }
        catch (XMLStreamException e) {
            throw new XPathException(e);
        }
    }

    public void close() throws XPathException {
        try {
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new XPathException(e);
        }
    }

    public boolean usesTypeAnnotations() {
        return false;
    }
}

