/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsMLKemDomain;

public class BcTlsMLKem
implements TlsAgreement {
    protected final BcTlsMLKemDomain domain;
    protected MLKEMPrivateKeyParameters privateKey;
    protected MLKEMPublicKeyParameters publicKey;
    protected TlsSecret secret;

    public BcTlsMLKem(BcTlsMLKemDomain bcTlsMLKemDomain) {
        this.domain = bcTlsMLKemDomain;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        if (this.domain.isServer()) {
            SecretWithEncapsulation secretWithEncapsulation = this.domain.encapsulate(this.publicKey);
            this.publicKey = null;
            this.secret = this.domain.adoptLocalSecret(secretWithEncapsulation.getSecret());
            return secretWithEncapsulation.getEncapsulation();
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.domain.generateKeyPair();
        this.privateKey = (MLKEMPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return this.domain.encodePublicKey((MLKEMPublicKeyParameters)asymmetricCipherKeyPair.getPublic());
    }

    @Override
    public void receivePeerValue(byte[] byArray) throws IOException {
        if (this.domain.isServer()) {
            this.publicKey = this.domain.decodePublicKey(byArray);
        } else {
            this.secret = this.domain.decapsulate(this.privateKey, byArray);
            this.privateKey = null;
        }
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        TlsSecret tlsSecret = this.secret;
        this.secret = null;
        return tlsSecret;
    }
}

