/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql.jdbcwrapper;

import ca.sqlpower.sql.CachedRowSet;
import ca.sqlpower.sql.SQL;
import ca.sqlpower.sql.jdbcwrapper.ConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.DatabaseMetaDataDecorator;
import ca.sqlpower.sql.jdbcwrapper.GenericResultSetDecorator;
import ca.sqlpower.sql.jdbcwrapper.GenericStatementDecorator;
import ca.sqlpower.sql.jdbcwrapper.ResultSetDecorator;
import ca.sqlpower.sql.jdbcwrapper.StatementDecorator;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PostgresDatabaseMetaDataDecorator
extends DatabaseMetaDataDecorator {
    private static final Logger logger = Logger.getLogger(PostgresDatabaseMetaDataDecorator.class);
    public static final int UGLY_DEFAULT_VARCHAR_SIZE = 1024;
    private static final int DIGITS_IN_INT8 = 20;
    private static final int DIGITS_IN_INT4 = 10;
    private static final int DIGITS_IN_FLOAT4 = 38;
    private static final int DIGITS_IN_FLOAT8 = 308;

    public PostgresDatabaseMetaDataDecorator(DatabaseMetaData delegate, ConnectionDecorator connectionDecorator) {
        super(delegate, connectionDecorator);
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "Database";
    }

    @Override
    @SuppressWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="A prepared statement is not necessary, as the statement contains no user input, and is called infrequently.")
    public ResultSet getCatalogs() throws SQLException {
        String theCatalog = this.getConnection().getCatalog();
        if (theCatalog == null || theCatalog.length() == 0) {
            theCatalog = this.getUserName();
        }
        Statement st = null;
        ResultSet rs = null;
        CachedRowSet crs = new CachedRowSet();
        st = this.getConnection().createStatement();
        rs = st.executeQuery("SELECT '" + theCatalog + "'");
        crs.populate(rs);
        rs.close();
        st.close();
        return crs;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        boolean fudgeAutoInc;
        ResultSet rs = super.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        CachedRowSet crs = new CachedRowSet();
        if (rs.getMetaData().getColumnCount() <= 22) {
            crs.populate(rs, null, "IS_AUTOINCREMENT");
            fudgeAutoInc = true;
        } else {
            crs.populate(rs);
            fudgeAutoInc = false;
        }
        int autoIncColNum = crs.findColumn("IS_AUTOINCREMENT");
        rs.close();
        while (crs.next()) {
            if (crs.getInt(5) == 12 && crs.getInt(7) <= 0) {
                crs.updateInt(7, 1024);
            } else if ("int4".equalsIgnoreCase(crs.getString(6))) {
                crs.updateInt(7, 10);
            } else if ("int8".equalsIgnoreCase(crs.getString(6))) {
                crs.updateInt(7, 20);
            } else if ("float4".equalsIgnoreCase(crs.getString(6))) {
                crs.updateInt(7, 38);
            } else if ("float8".equalsIgnoreCase(crs.getString(6))) {
                crs.updateInt(7, 308);
            } else if ("bool".equalsIgnoreCase(crs.getString(6))) {
                crs.updateInt(5, 16);
            }
            if (!fudgeAutoInc) continue;
            if ("serial".equalsIgnoreCase(crs.getString(6))) {
                crs.updateString(autoIncColNum, "YES");
                continue;
            }
            crs.updateString(autoIncColNum, "NO");
        }
        crs.beforeFirst();
        return crs;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        ResultSet rs = super.getIndexInfo(catalog, schema, table, unique, approximate);
        CachedRowSet crs = new CachedRowSet();
        crs.populate(rs, null, "SPG_INDEX_TYPE");
        rs.close();
        Map<Object, Object> indexTypes = new HashMap();
        indexTypes = this.getIndexType(table);
        Pattern p = Pattern.compile("^\"(.*)\"$");
        while (crs.next()) {
            String colName = crs.getString(9);
            Matcher m = p.matcher(colName);
            if (colName != null && m.matches()) {
                crs.updateString(9, m.group(1));
            }
            crs.updateShort(7, (short)Short.valueOf(crs.getString(7)));
            logger.debug((Object)("crs.getString(6) is returning " + crs.getString(6)));
            logger.debug((Object)("Setting index type to " + (String)indexTypes.get(crs.getString(6))));
            logger.debug((Object)("JDBC Type?: " + crs.getShort(7)));
            crs.updateString("SPG_INDEX_TYPE", ((String)indexTypes.get(crs.getString(6))).toUpperCase());
        }
        crs.beforeFirst();
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getIndexType(String tableName) throws SQLException {
        HashMap<String, String> indexTypes = new HashMap<String, String>();
        Statement stmt = null;
        ResultSet rs = null;
        String type = "OTHER";
        String name = "";
        try {
            stmt = this.getConnection().createStatement();
            String sql = "SELECT i.tablename as table, i.indexname, am.amname as indextype from pg_indexes i left join pg_class ci on i.indexname = ci.relname left join pg_am am on ci.relam = am.oid where i.tablename=" + SQL.quote(tableName);
            logger.debug((Object)("SQL statement was " + sql));
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                name = rs.getString("indexname");
                type = rs.getString("indextype");
                indexTypes.put(name, type);
            }
            HashMap<String, String> hashMap = indexTypes;
            return hashMap;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    protected ResultSetDecorator wrap(ResultSet rs) throws SQLException {
        return new GenericResultSetDecorator(this.wrap(rs.getStatement()), rs);
    }

    @Override
    protected StatementDecorator wrap(Statement statement) {
        return new GenericStatementDecorator(this.connectionDecorator, statement);
    }
}

