/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables.internal;

import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TableJiraRenderer
implements NodeRenderer {
    public TableJiraRenderer(DataHolder options) {
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler(TableBlock.class, this::render), new NodeRenderingHandler(TableHead.class, this::render), new NodeRenderingHandler(TableSeparator.class, this::render), new NodeRenderingHandler(TableBody.class, this::render), new NodeRenderingHandler(TableRow.class, this::render), new NodeRenderingHandler(TableCell.class, this::render)));
    }

    private HtmlWriter tailBlankLine(Node node, HtmlWriter html) {
        return this.tailBlankLine(node, 1, html);
    }

    public boolean isLastBlockQuoteChild(Node node) {
        Node parent = node.getParent();
        return parent instanceof BlockQuote && parent.getLastChild() == node;
    }

    public HtmlWriter tailBlankLine(Node node, int count, HtmlWriter html) {
        if (this.isLastBlockQuoteChild(node)) {
            BasedSequence prefix = html.getPrefix();
            html.popPrefix();
            html.blankLine(count);
            html.pushPrefix();
            html.setPrefix((CharSequence)prefix, false);
        } else {
            html.blankLine(count);
        }
        return html;
    }

    private void render(TableBlock node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren((Node)node);
        this.tailBlankLine((Node)node, html);
    }

    private void render(TableHead node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren((Node)node);
    }

    private void render(TableSeparator tableSeparator, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(TableBody node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren((Node)node);
    }

    private void render(TableRow node, NodeRendererContext context, HtmlWriter html) {
        if (node.getParent() instanceof TableHead) {
            ((HtmlWriter)html.line()).raw((CharSequence)"||");
        } else if (node.getParent() instanceof TableBody) {
            ((HtmlWriter)html.line()).raw((CharSequence)"|");
        }
        context.renderChildren((Node)node);
        html.line();
    }

    private void render(TableCell node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren((Node)node);
        if (node.getGrandParent() instanceof TableHead) {
            html.raw((CharSequence)"||");
        } else if (node.getGrandParent() instanceof TableBody) {
            html.raw((CharSequence)"|");
        }
    }

    private static String getAlignValue(TableCell.Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return "left";
            }
            case CENTER: {
                return "center";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new IllegalStateException("Unknown alignment: " + (Object)((Object)alignment));
    }

    public static class Factory
    implements NodeRendererFactory {
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new TableJiraRenderer(options);
        }
    }
}

