/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Table;
import net.sf.mpxj.TableContainer;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskContainer;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.View;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.MPPResourceField;
import net.sf.mpxj.common.MPPTaskField;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.RtfHelper;
import net.sf.mpxj.mpp.AvailabilityFactory;
import net.sf.mpxj.mpp.ConstraintFactory;
import net.sf.mpxj.mpp.CostRateTableFactory;
import net.sf.mpxj.mpp.CustomFieldValueReader9;
import net.sf.mpxj.mpp.DocumentInputStreamFactory;
import net.sf.mpxj.mpp.FieldMap;
import net.sf.mpxj.mpp.FieldMap9;
import net.sf.mpxj.mpp.FilterReader9;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.GraphicalIndicatorReader;
import net.sf.mpxj.mpp.GroupReader9;
import net.sf.mpxj.mpp.MPP9CalendarFactory;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.mpp.ProjectPropertiesReader;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Props9;
import net.sf.mpxj.mpp.PropsBlock;
import net.sf.mpxj.mpp.RecurringTaskReader;
import net.sf.mpxj.mpp.ResourceAssignmentFactory;
import net.sf.mpxj.mpp.TableFactory;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta9;
import net.sf.mpxj.mpp.ViewFactory9;
import net.sf.mpxj.mpp.ViewStateReader9;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

final class MPP9Reader
implements MPPVariantReader {
    private MPPReader m_reader;
    private ProjectFile m_file;
    private EventManager m_eventManager;
    private DirectoryEntry m_root;
    private HashMap<Integer, ProjectCalendar> m_resourceMap;
    private Var2Data m_outlineCodeVarData;
    private Props9 m_projectProps;
    private Map<Integer, FontBase> m_fontBases;
    private Map<Integer, SubProject> m_taskSubProjects;
    private DirectoryEntry m_projectDir;
    private DirectoryEntry m_viewDir;
    private DocumentInputStreamFactory m_inputStreamFactory;
    private static final int SUBPROJECT_LISTEND = 771;
    private static final int SUBPROJECT_TASKUNIQUEID0 = 0;
    private static final int SUBPROJECT_TASKUNIQUEID1 = 187957248;
    private static final int SUBPROJECT_TASKUNIQUEID2 = 0xABB0000;
    private static final int SUBPROJECT_TASKUNIQUEID3 = 94437376;
    private static final int SUBPROJECT_TASKUNIQUEID4 = 49741824;
    private static final int SUBPROJECT_TASKUNIQUEID5 = 0x7010000;
    private static final Integer TABLE_COLUMN_DATA_STANDARD = 1;
    private static final Integer TABLE_COLUMN_DATA_ENTERPRISE = 2;
    private static final Integer TABLE_COLUMN_DATA_BASELINE = null;
    private static final Integer OUTLINECODE_DATA = 1;
    private static final int DURATION_CONFIRMED_MASK = 32;
    private static final int TASK_UNIQUE_ID_FIXED_OFFSET = 0;
    private static final int TASK_ID_FIXED_OFFSET = 4;
    private static final int NULL_TASK_BLOCK_SIZE = 8;
    private static final Map<Integer, FieldType> RESOURCE_FIELD_ALIASES = new HashMap<Integer, FieldType>();
    private static final Map<Integer, FieldType> TASK_FIELD_ALIASES;

    MPP9Reader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(MPPReader mPPReader, ProjectFile projectFile, DirectoryEntry directoryEntry) throws MPXJException, IOException {
        try {
            this.populateMemberData(mPPReader, projectFile, directoryEntry);
            this.processProjectProperties();
            if (!mPPReader.getReadPropertiesOnly()) {
                this.processSubProjectData();
                this.processGraphicalIndicators();
                this.processCustomValueLists();
                this.processCalendarData();
                this.processResourceData();
                this.processTaskData();
                this.processConstraintData();
                this.processAssignmentData();
                this.postProcessTasks();
                if (mPPReader.getReadPresentationData()) {
                    this.processViewPropertyData();
                    this.processTableData();
                    this.processViewData();
                    this.processFilterData();
                    this.processGroupData();
                    this.processSavedViewState();
                }
            }
        }
        finally {
            this.clearMemberData();
        }
    }

    private void populateMemberData(MPPReader mPPReader, ProjectFile projectFile, DirectoryEntry directoryEntry) throws MPXJException, IOException {
        Object object;
        this.m_reader = mPPReader;
        this.m_file = projectFile;
        this.m_eventManager = projectFile.getEventManager();
        this.m_root = directoryEntry;
        Props9 props9 = new Props9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Props9")));
        projectFile.getProjectProperties().setProjectFilePath(props9.getUnicodeString(Props.PROJECT_FILE_PATH));
        this.m_inputStreamFactory = new DocumentInputStreamFactory(props9);
        if (!((props9.getByte(Props.PASSWORD_FLAG) & 1) == 0 || (object = MPPUtility.decodePassword(props9.getByteArray(Props.PROTECTION_PASSWORD_HASH), this.m_inputStreamFactory.getEncryptionCode())) == null || ((String)object).length() <= 0 || mPPReader.getReadPassword() != null && mPPReader.getReadPassword().matches((String)object))) {
            throw new MPXJException("File is password protected. Please enter password.");
        }
        this.m_resourceMap = new HashMap();
        this.m_projectDir = (DirectoryEntry)directoryEntry.getEntry("   19");
        this.m_viewDir = (DirectoryEntry)directoryEntry.getEntry("   29");
        object = (DirectoryEntry)this.m_projectDir.getEntry("TBkndOutlCode");
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)object.getEntry("VarMeta")));
        this.m_outlineCodeVarData = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)object.getEntry("Var2Data")));
        this.m_projectProps = new Props9(this.m_inputStreamFactory.getInstance(this.m_projectDir, "Props"));
        this.m_fontBases = new HashMap<Integer, FontBase>();
        this.m_taskSubProjects = new HashMap<Integer, SubProject>();
        this.m_file.getProjectProperties().setMppFileType(9);
        this.m_file.getProjectProperties().setAutoFilter(props9.getBoolean(Props.AUTO_FILTER));
    }

    private void clearMemberData() {
        this.m_reader = null;
        this.m_file = null;
        this.m_eventManager = null;
        this.m_root = null;
        this.m_resourceMap = null;
        this.m_projectDir = null;
        this.m_viewDir = null;
        this.m_outlineCodeVarData = null;
        this.m_fontBases = null;
        this.m_taskSubProjects = null;
    }

    private void processProjectProperties() throws MPXJException {
        ProjectPropertiesReader projectPropertiesReader = new ProjectPropertiesReader();
        projectPropertiesReader.process(this.m_file, this.m_projectProps, this.m_root);
    }

    private void processGraphicalIndicators() {
        GraphicalIndicatorReader graphicalIndicatorReader = new GraphicalIndicatorReader();
        graphicalIndicatorReader.process(this.m_file.getCustomFields(), this.m_file.getProjectProperties(), this.m_projectProps);
    }

    private void processSubProjectData() {
        byte[] byArray = this.m_projectProps.getByteArray(Props.SUBPROJECT_DATA);
        if (byArray != null) {
            int n = 0;
            int n2 = 0;
            byte[] byArray2 = new byte[20];
            n2 += 4;
            int n3 = MPPUtility.getInt(byArray, n2 += 4);
            n2 += 4;
            block15: while (n2 < n3) {
                ++n;
                int n4 = MPPUtility.getShort(byArray, n2);
                n2 += 4;
                MPPUtility.getByteArray(byArray, n4, byArray2.length, byArray2, 0);
                byte by = byArray2[16];
                switch (by) {
                    case 0: {
                        n2 += 8;
                        continue block15;
                    }
                    case -103: 
                    case 9: 
                    case 13: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        n2 += 4;
                        int n6 = MPPUtility.getShort(byArray, n2 += 4);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        continue block15;
                    }
                    case -111: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 4);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        continue block15;
                    }
                    case 1: 
                    case 3: 
                    case 8: 
                    case 10: 
                    case 17: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 4);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        continue block15;
                    }
                    case -127: 
                    case 65: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        continue block15;
                    }
                    case -64: {
                        int n5 = n4;
                        int n6 = MPPUtility.getShort(byArray, n2);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        continue block15;
                    }
                    case 5: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 4);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        this.m_file.getSubProjects().setResourceSubProject(subProject);
                        continue block15;
                    }
                    case 69: {
                        int n5 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n6 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        this.m_file.getSubProjects().setResourceSubProject(subProject);
                        continue block15;
                    }
                    case 2: 
                    case 4: {
                        int n6 = MPPUtility.getShort(byArray, n2);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, -1, n6, n7, n);
                        if (by != 4) continue block15;
                        this.m_file.getSubProjects().setResourceSubProject(subProject);
                        continue block15;
                    }
                    case -115: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 8);
                        int n7 = MPPUtility.getShort(byArray, n2 += 8);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        continue block15;
                    }
                    case -128: {
                        n2 += 12;
                        continue block15;
                    }
                    case 16: {
                        n2 += 8;
                        continue block15;
                    }
                    case 68: {
                        int n6 = MPPUtility.getShort(byArray, n2);
                        n2 += 4;
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, -1, n6, n7, n);
                        this.m_file.getSubProjects().setResourceSubProject(subProject);
                        continue block15;
                    }
                }
                n2 += 12;
            }
        }
    }

    private SubProject readSubProject(byte[] byArray, int n, int n2, int n3, int n4) {
        try {
            int n5;
            SubProject subProject = new SubProject();
            if (n != -1) {
                n5 = 0;
                int n6 = MPPUtility.getInt(byArray, n);
                while (n6 != 771) {
                    switch (n6) {
                        case 0: 
                        case 49741824: 
                        case 94437376: 
                        case 0x7010000: 
                        case 0xABB0000: 
                        case 187957248: {
                            subProject.setTaskUniqueID(n5);
                            this.m_taskSubProjects.put(subProject.getTaskUniqueID(), subProject);
                            n5 = 0;
                            break;
                        }
                        default: {
                            if (n5 != 0) {
                                subProject.addExternalTaskUniqueID(n5);
                                this.m_taskSubProjects.put(n5, subProject);
                            }
                            n5 = n6;
                        }
                    }
                    n6 = MPPUtility.getInt(byArray, n += 4);
                }
                if (n5 != 0) {
                    subProject.addExternalTaskUniqueID(n5);
                    this.m_taskSubProjects.put(n5, subProject);
                }
                n6 = 0x800000 + (n4 - 1) * 0x400000;
                subProject.setUniqueIDOffset(n6);
            }
            n2 += 18;
            subProject.setDosFullPath(MPPUtility.getString(byArray, n2 += 4));
            n2 += subProject.getDosFullPath().length() + 1;
            n5 = MPPUtility.getInt(byArray, n2 += 24);
            n2 += 4;
            if (n5 == 0) {
                subProject.setFullPath(subProject.getDosFullPath());
            } else {
                n5 = MPPUtility.getInt(byArray, n2);
                n2 += 4;
                subProject.setFullPath(MPPUtility.getUnicodeString(byArray, n2 += 2, n5));
            }
            n3 += 18;
            subProject.setDosFileName(MPPUtility.getString(byArray, n3 += 4));
            n3 += subProject.getDosFileName().length() + 1;
            n5 = MPPUtility.getInt(byArray, n3 += 24);
            n3 += 4;
            if (n5 == 0) {
                subProject.setFileName(subProject.getDosFileName());
            } else {
                n5 = MPPUtility.getInt(byArray, n3);
                n3 += 4;
                subProject.setFileName(MPPUtility.getUnicodeString(byArray, n3 += 2, n5));
            }
            this.m_file.getSubProjects().add(subProject);
            return subProject;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private void processViewPropertyData() throws IOException {
        Props9 props9 = new Props9(this.m_inputStreamFactory.getInstance(this.m_viewDir, "Props"));
        byte[] byArray = props9.getByteArray(Props.FONT_BASES);
        if (byArray != null) {
            this.processBaseFonts(byArray);
        }
        ProjectProperties projectProperties = this.m_file.getProjectProperties();
        projectProperties.setShowProjectSummaryTask(props9.getBoolean(Props.SHOW_PROJECT_SUMMARY_TASK));
    }

    private void processBaseFonts(byte[] byArray) {
        int n = 0;
        int n2 = MPPUtility.getShort(byArray, 0);
        n += 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = MPPUtility.getShort(byArray, n += 2);
            String string = MPPUtility.getUnicodeString(byArray, n += 2);
            n += 64;
            if (string.length() == 0) continue;
            FontBase fontBase = new FontBase(i, string, n3);
            this.m_fontBases.put(fontBase.getIndex(), fontBase);
        }
    }

    private void processCustomValueLists() throws IOException {
        CustomFieldValueReader9 customFieldValueReader9 = new CustomFieldValueReader9(this.m_projectDir, this.m_file.getProjectProperties(), this.m_projectProps, this.m_file.getCustomFields());
        customFieldValueReader9.process();
    }

    public List<String> getTaskFieldDescriptions(byte[] byArray) {
        String string;
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < byArray.length; i += string.length() * 2 + 2) {
            string = MPPUtility.getUnicodeString(byArray, i);
            linkedList.add(string);
        }
        return linkedList;
    }

    public List<Object> getTaskFieldValues(ProjectProperties projectProperties, FieldType fieldType, byte[] byArray) {
        if (fieldType == null || byArray == null || byArray.length == 0) {
            return null;
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        switch (fieldType.getDataType()) {
            case DATE: {
                int n;
                while (n + 4 <= byArray.length) {
                    Date date = MPPUtility.getTimestamp(byArray, n);
                    linkedList.add(date);
                    n += 4;
                }
                break;
            }
            case CURRENCY: {
                int n;
                while (n + 8 <= byArray.length) {
                    Double d = NumberHelper.getDouble(MPPUtility.getDouble(byArray, n) / 100.0);
                    linkedList.add(d);
                    n += 8;
                }
                break;
            }
            case NUMERIC: {
                int n;
                while (n + 8 <= byArray.length) {
                    Double d = NumberHelper.getDouble(MPPUtility.getDouble(byArray, n));
                    linkedList.add(d);
                    n += 8;
                }
                break;
            }
            case DURATION: {
                int n;
                while (n + 6 <= byArray.length) {
                    Duration duration = MPPUtility.getAdjustedDuration(projectProperties, MPPUtility.getInt(byArray, n), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray, n + 4)));
                    linkedList.add(duration);
                    n += 6;
                }
                break;
            }
            case STRING: {
                String string;
                int n;
                for (n = 0; n < byArray.length; n += string.length() * 2 + 2) {
                    string = MPPUtility.getUnicodeString(byArray, n);
                    linkedList.add(string);
                }
                break;
            }
            case BOOLEAN: {
                int n;
                while (n + 2 <= byArray.length) {
                    boolean bl = MPPUtility.getShort(byArray, n) == 1;
                    linkedList.add(bl);
                    n += 2;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return linkedList;
    }

    private void processFieldNameAliases(Map<Integer, FieldType> map, byte[] byArray) {
        if (byArray != null) {
            int n = 0;
            int n2 = 0;
            CustomFieldContainer customFieldContainer = this.m_file.getCustomFields();
            while (n < byArray.length) {
                FieldType fieldType;
                String string = MPPUtility.getUnicodeString(byArray, n);
                if (!string.isEmpty() && (fieldType = map.get(n2)) != null) {
                    customFieldContainer.getCustomField(fieldType).setAlias(string);
                }
                n += (string.length() + 1) * 2;
                ++n2;
            }
        }
    }

    private TreeMap<Integer, Integer> createTaskMap(FieldMap fieldMap, FixedMeta fixedMeta, FixedData fixedData, Var2Data var2Data) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        int n = fieldMap.getFixedDataOffset(TaskField.UNIQUE_ID);
        Integer n2 = fieldMap.getVarDataKey(TaskField.NAME);
        int n3 = fixedMeta.getAdjustedItemCount();
        for (int i = 3; i < n3; ++i) {
            Integer n4;
            int n5;
            byte[] byArray = fixedData.getByteArrayValue(i);
            if (byArray == null) continue;
            byte[] byArray2 = fixedMeta.getByteArrayValue(i);
            int n6 = MPPUtility.getInt(byArray2, 0);
            if ((n6 & 2) != 0) {
                n5 = MPPUtility.getShort(byArray, 0);
                n4 = n5;
                if (treeMap.containsKey(n4)) continue;
                treeMap.put(n4, null);
                continue;
            }
            if (byArray.length == 8) {
                n5 = MPPUtility.getInt(byArray, 0);
                n4 = n5;
                if (treeMap.containsKey(n4)) continue;
                treeMap.put(n4, i);
                continue;
            }
            int n7 = fieldMap.getMaxFixedDataSize(0);
            if (n7 != 0 && byArray.length * 100 / n7 <= 75 || treeMap.containsKey(n4 = Integer.valueOf(n5 = MPPUtility.getInt(byArray, n))) && var2Data.getUnicodeString(n4, n2) == null) continue;
            treeMap.put(n4, i);
        }
        return treeMap;
    }

    private TreeMap<Integer, Integer> createResourceMap(FieldMap fieldMap, FixedMeta fixedMeta, FixedData fixedData) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        int n = fixedMeta.getAdjustedItemCount();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixedData.getByteArrayValue(i);
            if (byArray == null || byArray.length < fieldMap.getMaxFixedDataSize(0)) continue;
            Integer n2 = MPPUtility.getShort(byArray, 0);
            treeMap.put(n2, i);
        }
        return treeMap;
    }

    private void processCalendarData() throws IOException {
        MPP9CalendarFactory mPP9CalendarFactory = new MPP9CalendarFactory(this.m_file);
        mPP9CalendarFactory.processCalendarData(this.m_projectDir, this.m_projectProps, this.m_inputStreamFactory, this.m_resourceMap);
    }

    private void processTaskData() throws IOException {
        FieldMap9 fieldMap9 = new FieldMap9(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap9.createTaskFieldMap(this.m_projectProps);
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndTask");
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 47);
        FixedData fixedData = new FixedData(fixedMeta, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"), 768, fieldMap9.getMaxFixedDataSize(0));
        this.processFieldNameAliases(TASK_FIELD_ALIASES, this.m_projectProps.getByteArray(Props.TASK_FIELD_NAME_ALIASES));
        TreeMap<Integer, Integer> treeMap = this.createTaskMap(fieldMap9, fixedMeta, fixedData, var2Data);
        Object[] objectArray = treeMap.keySet().toArray();
        boolean bl = true;
        LinkedList<Task> linkedList = new LinkedList<Task>();
        RecurringTaskReader recurringTaskReader = null;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Task task;
            Integer n = (Integer)objectArray[i];
            Integer n2 = treeMap.get(n);
            if (!fixedData.isValidOffset(n2)) continue;
            byte[] byArray = fixedData.getByteArrayValue(n2);
            Integer n3 = MPPUtility.getInt(byArray, fieldMap9.getFixedDataOffset(TaskField.ID));
            if (byArray.length == 8) {
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(MPPUtility.getShort(byArray, 0));
                task.setID(MPPUtility.getShort(byArray, 4));
                continue;
            }
            if (byArray.length < fieldMap9.getMaxFixedDataSize(0) || n != 0 && !varMeta9.containsKey(n)) continue;
            byte[] byArray2 = fixedMeta.getByteArrayValue(n2);
            byte[] byArray3 = var2Data.getByteArray(n, fieldMap9.getVarDataKey(TaskField.RECURRING_DATA));
            Task task2 = this.m_file.getTaskByID(n3);
            if (task2 != null) {
                if (!varMeta9.getUniqueIdentifierSet().contains(n)) continue;
                if (task2.getName() == null) {
                    this.m_file.removeTask(task2);
                }
            }
            task = this.m_file.addTask();
            task.disableEvents();
            fieldMap9.populateContainer(TaskField.class, task, n, new byte[][]{byArray}, var2Data);
            task.enableEvents();
            task.setEffortDriven((byArray2[11] & 0x10) != 0);
            task.setEstimated(this.getDurationEstimated(MPPUtility.getShort(byArray, fieldMap9.getFixedDataOffset(TaskField.ACTUAL_DURATION_UNITS))));
            task.setExpanded((byArray2[12] & 2) == 0);
            Integer n4 = task.getSubprojectTaskID();
            if (n4 != null && n4 != 0) {
                task.setSubprojectTaskID(n4);
                task.setExternalTask(true);
                linkedList.add(task);
            }
            task.setFlag(1, (byArray2[37] & 0x20) != 0);
            task.setFlag(2, (byArray2[37] & 0x40) != 0);
            task.setFlag(3, (byArray2[37] & 0x80) != 0);
            task.setFlag(4, (byArray2[38] & 1) != 0);
            task.setFlag(5, (byArray2[38] & 2) != 0);
            task.setFlag(6, (byArray2[38] & 4) != 0);
            task.setFlag(7, (byArray2[38] & 8) != 0);
            task.setFlag(8, (byArray2[38] & 0x10) != 0);
            task.setFlag(9, (byArray2[38] & 0x20) != 0);
            task.setFlag(10, (byArray2[38] & 0x40) != 0);
            task.setFlag(11, (byArray2[38] & 0x80) != 0);
            task.setFlag(12, (byArray2[39] & 1) != 0);
            task.setFlag(13, (byArray2[39] & 2) != 0);
            task.setFlag(14, (byArray2[39] & 4) != 0);
            task.setFlag(15, (byArray2[39] & 8) != 0);
            task.setFlag(16, (byArray2[39] & 0x10) != 0);
            task.setFlag(17, (byArray2[39] & 0x20) != 0);
            task.setFlag(18, (byArray2[39] & 0x40) != 0);
            task.setFlag(19, (byArray2[39] & 0x80) != 0);
            task.setFlag(20, (byArray2[40] & 1) != 0);
            task.setHideBar((byArray2[10] & 0x80) != 0);
            this.processHyperlinkData(task, var2Data.getByteArray(n, fieldMap9.getVarDataKey(TaskField.HYPERLINK_DATA)));
            task.setID(n3);
            task.setIgnoreResourceCalendar((byArray2[10] & 2) != 0);
            task.setLevelAssignments((byArray2[13] & 4) != 0);
            task.setLevelingCanSplit((byArray2[13] & 2) != 0);
            task.setMarked((byArray2[9] & 0x40) != 0);
            task.setMilestone((byArray2[8] & 0x20) != 0);
            task.setOutlineCode(1, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE1_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(2, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE2_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(3, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE3_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(4, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE4_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(5, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE5_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(6, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE6_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(7, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE7_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(8, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE8_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(9, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE9_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(10, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE10_INDEX), OUTLINECODE_DATA));
            task.setRollup((byArray2[10] & 8) != 0);
            task.setUniqueID(n);
            switch (task.getConstraintType()) {
                case AS_LATE_AS_POSSIBLE: {
                    if (DateHelper.compare(task.getStart(), task.getLateStart()) < 0) {
                        task.setStart(task.getLateStart());
                    }
                    if (DateHelper.compare(task.getFinish(), task.getLateFinish()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
                case START_NO_LATER_THAN: 
                case FINISH_NO_LATER_THAN: {
                    if (DateHelper.compare(task.getFinish(), task.getStart()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
            }
            if (byArray3 != null) {
                if (recurringTaskReader == null) {
                    recurringTaskReader = new RecurringTaskReader(this.m_file.getProjectProperties());
                }
                recurringTaskReader.processRecurringTask(task, byArray3);
                task.setRecurring(true);
            }
            String string = task.getNotes();
            if (!this.m_reader.getPreserveNoteFormatting()) {
                string = RtfHelper.strip(string);
            }
            task.setNotes(string);
            Integer n5 = (Integer)task.getCachedValue(TaskField.CALENDAR_UNIQUE_ID);
            if (n5 != null && n5 != -1 && (object = this.m_file.getCalendarByUniqueID(n5)) != null) {
                task.setCalendar((ProjectCalendar)object);
            }
            object = this.m_taskSubProjects.get(task.getUniqueID());
            task.setSubProject((SubProject)object);
            if (object != null) {
                task.setExternalTask(((SubProject)object).isExternalTask(task.getUniqueID()));
                if (task.getExternalTask()) {
                    task.setExternalTaskProject(((SubProject)object).getFullPath());
                }
            }
            if (task.getWBS() != null) {
                bl = false;
            }
            if ((byArray2[9] & 0x80) == 0) {
                task.setSplits(new LinkedList<DateRange>());
            }
            if (task.getName() == null && (task.getStart() == null || task.getStart().getTime() == MPPUtility.getEpochDate().getTime() || task.getFinish() == null || task.getFinish().getTime() == MPPUtility.getEpochDate().getTime() || task.getCreateDate() == null || task.getCreateDate().getTime() == MPPUtility.getEpochDate().getTime())) {
                this.m_file.removeTask(task);
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(n);
                task.setID(n3);
                continue;
            }
            this.processTaskEnterpriseColumns(fieldMap9, task, var2Data);
            this.m_eventManager.fireTaskReadEvent(task);
        }
        this.m_file.getProjectConfig().setAutoWBS(bl);
        if (!linkedList.isEmpty()) {
            this.processExternalTasks(linkedList);
        }
    }

    private void processTaskEnterpriseColumns(FieldMap fieldMap, Task task, Var2Data var2Data) {
        byte[] byArray = null;
        Integer n = fieldMap.getVarDataKey(TaskField.ENTERPRISE_DATA);
        if (n != null) {
            byArray = var2Data.getByteArray(task.getUniqueID(), n);
        }
        if (byArray != null) {
            PropsBlock propsBlock = new PropsBlock(byArray);
            for (Integer n2 : propsBlock.keySet()) {
                int n3 = n2 - 0xB400000;
                TaskField taskField = MPPTaskField.getInstance(n3);
                if (taskField == null) continue;
                Object object = null;
                switch (taskField.getDataType()) {
                    case CURRENCY: {
                        object = propsBlock.getDouble(n2) / 100.0;
                        break;
                    }
                    case DATE: {
                        object = propsBlock.getTimestamp(n2);
                        break;
                    }
                    case WORK: {
                        double d = MPPUtility.getDouble(propsBlock.getByteArray(n2), 0) / 60000.0;
                        object = Duration.getInstance(d, TimeUnit.HOURS);
                        break;
                    }
                    case DURATION: {
                        byte[] byArray2 = propsBlock.getByteArray(n2);
                        double d = (double)MPPUtility.getInt(byArray2, 0) / 600.0;
                        TimeUnit timeUnit = byArray2.length < 6 ? TimeUnit.DAYS : MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray2, 4));
                        Duration duration = Duration.getInstance(d, TimeUnit.HOURS);
                        object = duration.convertUnits(timeUnit, this.m_file.getProjectProperties());
                        break;
                    }
                    case BOOLEAN: {
                        taskField = null;
                        int n4 = propsBlock.getInt(n2);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG1, (n4 & 2) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG2, (n4 & 4) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG3, (n4 & 8) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG4, (n4 & 0x10) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG5, (n4 & 0x20) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG6, (n4 & 0x40) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG7, (n4 & 0x80) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG8, (n4 & 0x100) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG9, (n4 & 0x200) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG10, (n4 & 0x400) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG11, (n4 & 0x800) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG12, (n4 & 0x1000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG13, (n4 & 0x2000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG14, (n4 & 0x4000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG15, (n4 & 0x8000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG16, (n4 & 0x10000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG17, (n4 & 0x20000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG18, (n4 & 0x40000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG19, (n4 & 0x80000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG20, (n4 & 0x100000) != 0 ? 1 : 0);
                        break;
                    }
                    case NUMERIC: {
                        object = propsBlock.getDouble(n2);
                        break;
                    }
                    case STRING: {
                        object = propsBlock.getUnicodeString(n2);
                        break;
                    }
                    case PERCENTAGE: {
                        object = propsBlock.getShort(n2);
                        break;
                    }
                }
                task.set((FieldType)taskField, object);
            }
        }
    }

    private void processResourceEnterpriseColumns(FieldMap fieldMap, Resource resource, Var2Data var2Data) {
        byte[] byArray = null;
        Integer n = fieldMap.getVarDataKey(ResourceField.ENTERPRISE_DATA);
        if (n != null) {
            byArray = var2Data.getByteArray(resource.getUniqueID(), n);
        }
        if (byArray != null) {
            PropsBlock propsBlock = new PropsBlock(byArray);
            resource.setCreationDate(propsBlock.getTimestamp(Props.RESOURCE_CREATION_DATE));
            for (Integer n2 : propsBlock.keySet()) {
                int n3 = n2 - 0xC400000;
                ResourceField resourceField = MPPResourceField.getInstance(n3);
                if (resourceField == null) continue;
                Object object = null;
                switch (resourceField.getDataType()) {
                    case CURRENCY: {
                        object = propsBlock.getDouble(n2) / 100.0;
                        break;
                    }
                    case DATE: {
                        object = propsBlock.getTimestamp(n2);
                        break;
                    }
                    case DURATION: {
                        byte[] byArray2 = propsBlock.getByteArray(n2);
                        double d = (double)MPPUtility.getInt(byArray2, 0) / 600.0;
                        TimeUnit timeUnit = byArray2.length < 6 ? TimeUnit.DAYS : MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray2, 4));
                        Duration duration = Duration.getInstance(d, TimeUnit.HOURS);
                        object = duration.convertUnits(timeUnit, this.m_file.getProjectProperties());
                        break;
                    }
                    case BOOLEAN: {
                        if (resourceField != ResourceField.FLAG1) break;
                        resourceField = null;
                        int n4 = propsBlock.getInt(n2);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG1, (n4 & 2) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG2, (n4 & 4) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG3, (n4 & 8) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG4, (n4 & 0x10) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG5, (n4 & 0x20) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG6, (n4 & 0x40) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG7, (n4 & 0x80) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG8, (n4 & 0x100) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG9, (n4 & 0x200) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG10, (n4 & 0x400) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG11, (n4 & 0x800) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG12, (n4 & 0x1000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG13, (n4 & 0x2000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG14, (n4 & 0x4000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG15, (n4 & 0x8000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG16, (n4 & 0x10000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG17, (n4 & 0x20000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG18, (n4 & 0x40000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG19, (n4 & 0x80000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG20, (n4 & 0x100000) != 0 ? 1 : 0);
                        break;
                    }
                    case NUMERIC: {
                        object = propsBlock.getDouble(n2);
                        break;
                    }
                    case STRING: {
                        object = propsBlock.getUnicodeString(n2);
                        break;
                    }
                }
                resource.set((FieldType)resourceField, object);
            }
        }
    }

    private void processExternalTasks(List<Task> list) {
        Collections.sort(list);
        SubProject subProject = null;
        for (Task task : list) {
            SubProject subProject2 = task.getSubProject();
            if (subProject2 == null) {
                task.setSubProject(subProject);
                if (subProject != null) {
                    task.setExternalTaskProject(subProject.getFullPath());
                }
            } else {
                subProject = subProject2;
            }
            if (subProject == null) continue;
            task.setProject(subProject.getFullPath());
        }
    }

    private void processHyperlinkData(Task task, byte[] byArray) {
        if (byArray != null) {
            int n = 12;
            String string = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string.length() + 1) * 2;
            String string2 = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string2.length() + 1) * 2;
            String string3 = MPPUtility.getUnicodeString(byArray, n += 12);
            task.setHyperlink(string);
            task.setHyperlinkAddress(string2);
            task.setHyperlinkSubAddress(string3);
        }
    }

    private void processHyperlinkData(Resource resource, byte[] byArray) {
        if (byArray != null) {
            int n = 12;
            String string = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string.length() + 1) * 2;
            String string2 = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string2.length() + 1) * 2;
            String string3 = MPPUtility.getUnicodeString(byArray, n += 12);
            resource.setHyperlink(string);
            resource.setHyperlinkAddress(string2);
            resource.setHyperlinkSubAddress(string3);
        }
    }

    private void processConstraintData() throws IOException {
        ConstraintFactory constraintFactory = new ConstraintFactory();
        constraintFactory.process(this.m_projectDir, this.m_file, this.m_inputStreamFactory);
    }

    private void processResourceData() throws IOException {
        FieldMap9 fieldMap9 = new FieldMap9(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap9.createResourceFieldMap(this.m_projectProps);
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc");
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 37);
        FixedData fixedData = new FixedData(fixedMeta, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"));
        this.processFieldNameAliases(RESOURCE_FIELD_ALIASES, this.m_projectProps.getByteArray(Props.RESOURCE_FIELD_NAME_ALIASES));
        TreeMap<Integer, Integer> treeMap = this.createResourceMap(fieldMap9, fixedMeta, fixedData);
        Integer[] integerArray = varMeta9.getUniqueIdentifierArray();
        for (int i = 0; i < integerArray.length; ++i) {
            Integer n = integerArray[i];
            Integer n2 = treeMap.get(n);
            if (n2 == null) continue;
            byte[] byArray = fixedData.getByteArrayValue(n2);
            Resource resource = this.m_file.addResource();
            resource.disableEvents();
            fieldMap9.populateContainer(ResourceField.class, resource, n, new byte[][]{byArray}, var2Data);
            resource.enableEvents();
            this.processHyperlinkData(resource, var2Data.getByteArray(n, fieldMap9.getVarDataKey(ResourceField.HYPERLINK_DATA)));
            resource.setID(MPPUtility.getInt(byArray, 4));
            resource.setOutlineCode1(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE1_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode2(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE2_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode3(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE3_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode4(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE4_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode5(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE5_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode6(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE6_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode7(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE7_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode8(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE8_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode9(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE9_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode10(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE10_INDEX), OUTLINECODE_DATA));
            resource.setType(MPPUtility.getShort(byArray, fieldMap9.getFixedDataOffset(ResourceField.WORKGROUP)) == 0 ? ResourceType.WORK : ResourceType.MATERIAL);
            resource.setUniqueID(n);
            byte[] byArray2 = fixedMeta.getByteArrayValue(n2);
            resource.setFlag(1, (byArray2[28] & 0x40) != 0);
            resource.setFlag(2, (byArray2[28] & 0x80) != 0);
            resource.setFlag(3, (byArray2[29] & 1) != 0);
            resource.setFlag(4, (byArray2[29] & 2) != 0);
            resource.setFlag(5, (byArray2[29] & 4) != 0);
            resource.setFlag(6, (byArray2[29] & 8) != 0);
            resource.setFlag(7, (byArray2[29] & 0x10) != 0);
            resource.setFlag(8, (byArray2[29] & 0x20) != 0);
            resource.setFlag(9, (byArray2[29] & 0x40) != 0);
            resource.setFlag(10, (byArray2[28] & 0x20) != 0);
            resource.setFlag(11, (byArray2[29] & 0x80) != 0);
            resource.setFlag(12, (byArray2[30] & 1) != 0);
            resource.setFlag(13, (byArray2[30] & 2) != 0);
            resource.setFlag(14, (byArray2[30] & 4) != 0);
            resource.setFlag(15, (byArray2[30] & 8) != 0);
            resource.setFlag(16, (byArray2[30] & 0x10) != 0);
            resource.setFlag(17, (byArray2[30] & 0x20) != 0);
            resource.setFlag(18, (byArray2[30] & 0x40) != 0);
            resource.setFlag(19, (byArray2[30] & 0x80) != 0);
            resource.setFlag(20, (byArray2[31] & 1) != 0);
            String string = resource.getNotes();
            if (!this.m_reader.getPreserveNoteFormatting()) {
                string = RtfHelper.strip(string);
            }
            resource.setNotes(string);
            resource.setResourceCalendar(this.m_resourceMap.get(n));
            this.processResourceEnterpriseColumns(fieldMap9, resource, var2Data);
            CostRateTableFactory costRateTableFactory = new CostRateTableFactory();
            costRateTableFactory.process(resource, 0, var2Data.getByteArray(n, fieldMap9.getVarDataKey(ResourceField.COST_RATE_A)));
            costRateTableFactory.process(resource, 1, var2Data.getByteArray(n, fieldMap9.getVarDataKey(ResourceField.COST_RATE_B)));
            costRateTableFactory.process(resource, 2, var2Data.getByteArray(n, fieldMap9.getVarDataKey(ResourceField.COST_RATE_C)));
            costRateTableFactory.process(resource, 3, var2Data.getByteArray(n, fieldMap9.getVarDataKey(ResourceField.COST_RATE_D)));
            costRateTableFactory.process(resource, 4, var2Data.getByteArray(n, fieldMap9.getVarDataKey(ResourceField.COST_RATE_E)));
            AvailabilityFactory availabilityFactory = new AvailabilityFactory();
            availabilityFactory.process(resource.getAvailability(), var2Data.getByteArray(n, fieldMap9.getVarDataKey(ResourceField.AVAILABILITY_DATA)));
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processAssignmentData() throws IOException {
        FieldMap9 fieldMap9 = new FieldMap9(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap9.createAssignmentFieldMap(this.m_projectProps);
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndAssn");
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 34);
        FixedData fixedData = new FixedData(142, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"));
        if (fixedData.getItemCount() != fixedMeta.getAdjustedItemCount()) {
            fixedData = new FixedData(fixedMeta, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"));
        }
        ResourceAssignmentFactory resourceAssignmentFactory = new ResourceAssignmentFactory();
        resourceAssignmentFactory.process(this.m_file, fieldMap9, null, this.m_reader.getUseRawTimephasedData(), this.m_reader.getPreserveNoteFormatting(), varMeta9, var2Data, fixedMeta, fixedData, null, fixedMeta.getAdjustedItemCount());
    }

    private boolean getDurationEstimated(int n) {
        return (n & 0x20) != 0;
    }

    private void processViewData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CV_iew");
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(122, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"));
        int n = fixedMeta.getAdjustedItemCount();
        ViewFactory9 viewFactory9 = new ViewFactory9();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixedMeta.getByteArrayValue(i);
            int n3 = MPPUtility.getShort(byArray, 4);
            if (n3 <= n2) continue;
            byte[] byArray2 = fixedData.getByteArrayValue(fixedData.getIndexFromOffset(n3));
            if (byArray2 != null) {
                View view = viewFactory9.createView(this.m_file, byArray, byArray2, var2Data, this.m_fontBases);
                this.m_file.getViews().add(view);
            }
            n2 = n3;
        }
    }

    private void processTableData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CTable");
        InputStream inputStream = this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData");
        int n = inputStream.available() % 115 == 0 ? 115 : 110;
        FixedData fixedData = new FixedData(n, inputStream);
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        TableContainer tableContainer = this.m_file.getTables();
        TableFactory tableFactory = new TableFactory(TABLE_COLUMN_DATA_STANDARD, TABLE_COLUMN_DATA_ENTERPRISE, TABLE_COLUMN_DATA_BASELINE);
        int n2 = fixedData.getItemCount();
        for (int i = 0; i < n2; ++i) {
            byte[] byArray = fixedData.getByteArrayValue(i);
            Table table = tableFactory.createTable(this.m_file, byArray, varMeta9, var2Data);
            tableContainer.add(table);
        }
    }

    private void processFilterData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CFilter");
        InputStream inputStream = this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData");
        int n = inputStream.available() % 115 == 0 ? 115 : 110;
        FixedData fixedData = new FixedData(n, inputStream, true);
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FilterReader9 filterReader9 = new FilterReader9();
        filterReader9.process(this.m_file.getProjectProperties(), this.m_file.getFilters(), fixedData, var2Data);
    }

    private void processGroupData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CGrouping");
        FixedData fixedData = new FixedData(110, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"));
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        GroupReader9 groupReader9 = new GroupReader9();
        groupReader9.process(this.m_file, fixedData, var2Data, this.m_fontBases);
    }

    private void processSavedViewState() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CEdl");
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        InputStream inputStream = this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData");
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        ViewStateReader9 viewStateReader9 = new ViewStateReader9();
        viewStateReader9.process(this.m_file, var2Data, byArray);
    }

    private void postProcessTasks() {
        TaskContainer taskContainer = this.m_file.getTasks();
        if (taskContainer.size() > 1) {
            Collections.sort(taskContainer);
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < taskContainer.size(); ++i) {
                Task task = (Task)taskContainer.get(i);
                n = NumberHelper.getInt(task.getID());
                if (!task.getNull() && n2 != -1 && n > n2 + 1) {
                    task.setNull(true);
                    continue;
                }
                n2 = n;
            }
        }
    }

    static {
        RESOURCE_FIELD_ALIASES.put(52, ResourceField.TEXT1);
        RESOURCE_FIELD_ALIASES.put(53, ResourceField.TEXT2);
        RESOURCE_FIELD_ALIASES.put(54, ResourceField.TEXT3);
        RESOURCE_FIELD_ALIASES.put(55, ResourceField.TEXT4);
        RESOURCE_FIELD_ALIASES.put(56, ResourceField.TEXT5);
        RESOURCE_FIELD_ALIASES.put(57, ResourceField.TEXT6);
        RESOURCE_FIELD_ALIASES.put(58, ResourceField.TEXT7);
        RESOURCE_FIELD_ALIASES.put(59, ResourceField.TEXT8);
        RESOURCE_FIELD_ALIASES.put(60, ResourceField.TEXT9);
        RESOURCE_FIELD_ALIASES.put(61, ResourceField.TEXT10);
        RESOURCE_FIELD_ALIASES.put(62, ResourceField.TEXT11);
        RESOURCE_FIELD_ALIASES.put(63, ResourceField.TEXT12);
        RESOURCE_FIELD_ALIASES.put(64, ResourceField.TEXT13);
        RESOURCE_FIELD_ALIASES.put(65, ResourceField.TEXT14);
        RESOURCE_FIELD_ALIASES.put(66, ResourceField.TEXT15);
        RESOURCE_FIELD_ALIASES.put(67, ResourceField.TEXT16);
        RESOURCE_FIELD_ALIASES.put(68, ResourceField.TEXT17);
        RESOURCE_FIELD_ALIASES.put(69, ResourceField.TEXT18);
        RESOURCE_FIELD_ALIASES.put(70, ResourceField.TEXT19);
        RESOURCE_FIELD_ALIASES.put(71, ResourceField.TEXT20);
        RESOURCE_FIELD_ALIASES.put(72, ResourceField.TEXT21);
        RESOURCE_FIELD_ALIASES.put(73, ResourceField.TEXT22);
        RESOURCE_FIELD_ALIASES.put(74, ResourceField.TEXT23);
        RESOURCE_FIELD_ALIASES.put(75, ResourceField.TEXT24);
        RESOURCE_FIELD_ALIASES.put(76, ResourceField.TEXT25);
        RESOURCE_FIELD_ALIASES.put(77, ResourceField.TEXT26);
        RESOURCE_FIELD_ALIASES.put(78, ResourceField.TEXT27);
        RESOURCE_FIELD_ALIASES.put(79, ResourceField.TEXT28);
        RESOURCE_FIELD_ALIASES.put(80, ResourceField.TEXT29);
        RESOURCE_FIELD_ALIASES.put(81, ResourceField.TEXT30);
        RESOURCE_FIELD_ALIASES.put(82, ResourceField.START1);
        RESOURCE_FIELD_ALIASES.put(83, ResourceField.START2);
        RESOURCE_FIELD_ALIASES.put(84, ResourceField.START3);
        RESOURCE_FIELD_ALIASES.put(85, ResourceField.START4);
        RESOURCE_FIELD_ALIASES.put(86, ResourceField.START5);
        RESOURCE_FIELD_ALIASES.put(87, ResourceField.START6);
        RESOURCE_FIELD_ALIASES.put(88, ResourceField.START7);
        RESOURCE_FIELD_ALIASES.put(89, ResourceField.START8);
        RESOURCE_FIELD_ALIASES.put(90, ResourceField.START9);
        RESOURCE_FIELD_ALIASES.put(91, ResourceField.START10);
        RESOURCE_FIELD_ALIASES.put(92, ResourceField.FINISH1);
        RESOURCE_FIELD_ALIASES.put(93, ResourceField.FINISH2);
        RESOURCE_FIELD_ALIASES.put(94, ResourceField.FINISH3);
        RESOURCE_FIELD_ALIASES.put(95, ResourceField.FINISH4);
        RESOURCE_FIELD_ALIASES.put(96, ResourceField.FINISH5);
        RESOURCE_FIELD_ALIASES.put(97, ResourceField.FINISH6);
        RESOURCE_FIELD_ALIASES.put(98, ResourceField.FINISH7);
        RESOURCE_FIELD_ALIASES.put(99, ResourceField.FINISH8);
        RESOURCE_FIELD_ALIASES.put(100, ResourceField.FINISH9);
        RESOURCE_FIELD_ALIASES.put(101, ResourceField.FINISH10);
        RESOURCE_FIELD_ALIASES.put(102, ResourceField.NUMBER1);
        RESOURCE_FIELD_ALIASES.put(103, ResourceField.NUMBER2);
        RESOURCE_FIELD_ALIASES.put(104, ResourceField.NUMBER3);
        RESOURCE_FIELD_ALIASES.put(105, ResourceField.NUMBER4);
        RESOURCE_FIELD_ALIASES.put(106, ResourceField.NUMBER5);
        RESOURCE_FIELD_ALIASES.put(107, ResourceField.NUMBER6);
        RESOURCE_FIELD_ALIASES.put(108, ResourceField.NUMBER7);
        RESOURCE_FIELD_ALIASES.put(109, ResourceField.NUMBER8);
        RESOURCE_FIELD_ALIASES.put(110, ResourceField.NUMBER9);
        RESOURCE_FIELD_ALIASES.put(111, ResourceField.NUMBER10);
        RESOURCE_FIELD_ALIASES.put(112, ResourceField.NUMBER11);
        RESOURCE_FIELD_ALIASES.put(113, ResourceField.NUMBER12);
        RESOURCE_FIELD_ALIASES.put(114, ResourceField.NUMBER13);
        RESOURCE_FIELD_ALIASES.put(115, ResourceField.NUMBER14);
        RESOURCE_FIELD_ALIASES.put(116, ResourceField.NUMBER15);
        RESOURCE_FIELD_ALIASES.put(117, ResourceField.NUMBER16);
        RESOURCE_FIELD_ALIASES.put(118, ResourceField.NUMBER17);
        RESOURCE_FIELD_ALIASES.put(119, ResourceField.NUMBER18);
        RESOURCE_FIELD_ALIASES.put(120, ResourceField.NUMBER19);
        RESOURCE_FIELD_ALIASES.put(121, ResourceField.NUMBER20);
        RESOURCE_FIELD_ALIASES.put(122, ResourceField.DURATION1);
        RESOURCE_FIELD_ALIASES.put(123, ResourceField.DURATION2);
        RESOURCE_FIELD_ALIASES.put(124, ResourceField.DURATION3);
        RESOURCE_FIELD_ALIASES.put(125, ResourceField.DURATION4);
        RESOURCE_FIELD_ALIASES.put(126, ResourceField.DURATION5);
        RESOURCE_FIELD_ALIASES.put(127, ResourceField.DURATION6);
        RESOURCE_FIELD_ALIASES.put(128, ResourceField.DURATION7);
        RESOURCE_FIELD_ALIASES.put(129, ResourceField.DURATION8);
        RESOURCE_FIELD_ALIASES.put(130, ResourceField.DURATION9);
        RESOURCE_FIELD_ALIASES.put(131, ResourceField.DURATION10);
        RESOURCE_FIELD_ALIASES.put(145, ResourceField.DATE1);
        RESOURCE_FIELD_ALIASES.put(146, ResourceField.DATE2);
        RESOURCE_FIELD_ALIASES.put(147, ResourceField.DATE3);
        RESOURCE_FIELD_ALIASES.put(148, ResourceField.DATE4);
        RESOURCE_FIELD_ALIASES.put(149, ResourceField.DATE5);
        RESOURCE_FIELD_ALIASES.put(150, ResourceField.DATE6);
        RESOURCE_FIELD_ALIASES.put(151, ResourceField.DATE7);
        RESOURCE_FIELD_ALIASES.put(152, ResourceField.DATE8);
        RESOURCE_FIELD_ALIASES.put(153, ResourceField.DATE9);
        RESOURCE_FIELD_ALIASES.put(154, ResourceField.DATE10);
        RESOURCE_FIELD_ALIASES.put(155, ResourceField.OUTLINE_CODE1);
        RESOURCE_FIELD_ALIASES.put(156, ResourceField.OUTLINE_CODE2);
        RESOURCE_FIELD_ALIASES.put(157, ResourceField.OUTLINE_CODE3);
        RESOURCE_FIELD_ALIASES.put(158, ResourceField.OUTLINE_CODE4);
        RESOURCE_FIELD_ALIASES.put(159, ResourceField.OUTLINE_CODE5);
        RESOURCE_FIELD_ALIASES.put(160, ResourceField.OUTLINE_CODE6);
        RESOURCE_FIELD_ALIASES.put(161, ResourceField.OUTLINE_CODE7);
        RESOURCE_FIELD_ALIASES.put(162, ResourceField.OUTLINE_CODE8);
        RESOURCE_FIELD_ALIASES.put(163, ResourceField.OUTLINE_CODE9);
        RESOURCE_FIELD_ALIASES.put(164, ResourceField.OUTLINE_CODE10);
        RESOURCE_FIELD_ALIASES.put(165, ResourceField.FLAG10);
        RESOURCE_FIELD_ALIASES.put(166, ResourceField.FLAG1);
        RESOURCE_FIELD_ALIASES.put(167, ResourceField.FLAG2);
        RESOURCE_FIELD_ALIASES.put(168, ResourceField.FLAG3);
        RESOURCE_FIELD_ALIASES.put(169, ResourceField.FLAG4);
        RESOURCE_FIELD_ALIASES.put(170, ResourceField.FLAG5);
        RESOURCE_FIELD_ALIASES.put(171, ResourceField.FLAG6);
        RESOURCE_FIELD_ALIASES.put(172, ResourceField.FLAG7);
        RESOURCE_FIELD_ALIASES.put(173, ResourceField.FLAG8);
        RESOURCE_FIELD_ALIASES.put(174, ResourceField.FLAG9);
        RESOURCE_FIELD_ALIASES.put(175, ResourceField.FLAG11);
        RESOURCE_FIELD_ALIASES.put(176, ResourceField.FLAG12);
        RESOURCE_FIELD_ALIASES.put(177, ResourceField.FLAG13);
        RESOURCE_FIELD_ALIASES.put(178, ResourceField.FLAG14);
        RESOURCE_FIELD_ALIASES.put(179, ResourceField.FLAG15);
        RESOURCE_FIELD_ALIASES.put(180, ResourceField.FLAG16);
        RESOURCE_FIELD_ALIASES.put(181, ResourceField.FLAG17);
        RESOURCE_FIELD_ALIASES.put(182, ResourceField.FLAG18);
        RESOURCE_FIELD_ALIASES.put(183, ResourceField.FLAG19);
        RESOURCE_FIELD_ALIASES.put(184, ResourceField.FLAG20);
        RESOURCE_FIELD_ALIASES.put(207, ResourceField.COST1);
        RESOURCE_FIELD_ALIASES.put(208, ResourceField.COST2);
        RESOURCE_FIELD_ALIASES.put(209, ResourceField.COST3);
        RESOURCE_FIELD_ALIASES.put(210, ResourceField.COST4);
        RESOURCE_FIELD_ALIASES.put(211, ResourceField.COST5);
        RESOURCE_FIELD_ALIASES.put(212, ResourceField.COST6);
        RESOURCE_FIELD_ALIASES.put(213, ResourceField.COST7);
        RESOURCE_FIELD_ALIASES.put(214, ResourceField.COST8);
        RESOURCE_FIELD_ALIASES.put(215, ResourceField.COST9);
        RESOURCE_FIELD_ALIASES.put(216, ResourceField.COST10);
        TASK_FIELD_ALIASES = new HashMap<Integer, FieldType>();
        TASK_FIELD_ALIASES.put(118, TaskField.TEXT1);
        TASK_FIELD_ALIASES.put(119, TaskField.TEXT2);
        TASK_FIELD_ALIASES.put(120, TaskField.TEXT3);
        TASK_FIELD_ALIASES.put(121, TaskField.TEXT4);
        TASK_FIELD_ALIASES.put(122, TaskField.TEXT5);
        TASK_FIELD_ALIASES.put(123, TaskField.TEXT6);
        TASK_FIELD_ALIASES.put(124, TaskField.TEXT7);
        TASK_FIELD_ALIASES.put(125, TaskField.TEXT8);
        TASK_FIELD_ALIASES.put(126, TaskField.TEXT9);
        TASK_FIELD_ALIASES.put(127, TaskField.TEXT10);
        TASK_FIELD_ALIASES.put(128, TaskField.START1);
        TASK_FIELD_ALIASES.put(129, TaskField.FINISH1);
        TASK_FIELD_ALIASES.put(130, TaskField.START2);
        TASK_FIELD_ALIASES.put(131, TaskField.FINISH2);
        TASK_FIELD_ALIASES.put(132, TaskField.START3);
        TASK_FIELD_ALIASES.put(133, TaskField.FINISH3);
        TASK_FIELD_ALIASES.put(134, TaskField.START4);
        TASK_FIELD_ALIASES.put(135, TaskField.FINISH4);
        TASK_FIELD_ALIASES.put(136, TaskField.START5);
        TASK_FIELD_ALIASES.put(137, TaskField.FINISH5);
        TASK_FIELD_ALIASES.put(138, TaskField.START6);
        TASK_FIELD_ALIASES.put(139, TaskField.FINISH6);
        TASK_FIELD_ALIASES.put(140, TaskField.START7);
        TASK_FIELD_ALIASES.put(141, TaskField.FINISH7);
        TASK_FIELD_ALIASES.put(142, TaskField.START8);
        TASK_FIELD_ALIASES.put(143, TaskField.FINISH8);
        TASK_FIELD_ALIASES.put(144, TaskField.START9);
        TASK_FIELD_ALIASES.put(145, TaskField.FINISH9);
        TASK_FIELD_ALIASES.put(146, TaskField.START10);
        TASK_FIELD_ALIASES.put(147, TaskField.FINISH10);
        TASK_FIELD_ALIASES.put(149, TaskField.NUMBER1);
        TASK_FIELD_ALIASES.put(150, TaskField.NUMBER2);
        TASK_FIELD_ALIASES.put(151, TaskField.NUMBER3);
        TASK_FIELD_ALIASES.put(152, TaskField.NUMBER4);
        TASK_FIELD_ALIASES.put(153, TaskField.NUMBER5);
        TASK_FIELD_ALIASES.put(154, TaskField.NUMBER6);
        TASK_FIELD_ALIASES.put(155, TaskField.NUMBER7);
        TASK_FIELD_ALIASES.put(156, TaskField.NUMBER8);
        TASK_FIELD_ALIASES.put(157, TaskField.NUMBER9);
        TASK_FIELD_ALIASES.put(158, TaskField.NUMBER10);
        TASK_FIELD_ALIASES.put(159, TaskField.DURATION1);
        TASK_FIELD_ALIASES.put(161, TaskField.DURATION2);
        TASK_FIELD_ALIASES.put(163, TaskField.DURATION3);
        TASK_FIELD_ALIASES.put(165, TaskField.DURATION4);
        TASK_FIELD_ALIASES.put(167, TaskField.DURATION5);
        TASK_FIELD_ALIASES.put(169, TaskField.DURATION6);
        TASK_FIELD_ALIASES.put(171, TaskField.DURATION7);
        TASK_FIELD_ALIASES.put(173, TaskField.DURATION8);
        TASK_FIELD_ALIASES.put(175, TaskField.DURATION9);
        TASK_FIELD_ALIASES.put(177, TaskField.DURATION10);
        TASK_FIELD_ALIASES.put(184, TaskField.DATE1);
        TASK_FIELD_ALIASES.put(185, TaskField.DATE2);
        TASK_FIELD_ALIASES.put(186, TaskField.DATE3);
        TASK_FIELD_ALIASES.put(187, TaskField.DATE4);
        TASK_FIELD_ALIASES.put(188, TaskField.DATE5);
        TASK_FIELD_ALIASES.put(189, TaskField.DATE6);
        TASK_FIELD_ALIASES.put(190, TaskField.DATE7);
        TASK_FIELD_ALIASES.put(191, TaskField.DATE8);
        TASK_FIELD_ALIASES.put(192, TaskField.DATE9);
        TASK_FIELD_ALIASES.put(193, TaskField.DATE10);
        TASK_FIELD_ALIASES.put(194, TaskField.TEXT11);
        TASK_FIELD_ALIASES.put(195, TaskField.TEXT12);
        TASK_FIELD_ALIASES.put(196, TaskField.TEXT13);
        TASK_FIELD_ALIASES.put(197, TaskField.TEXT14);
        TASK_FIELD_ALIASES.put(198, TaskField.TEXT15);
        TASK_FIELD_ALIASES.put(199, TaskField.TEXT16);
        TASK_FIELD_ALIASES.put(200, TaskField.TEXT17);
        TASK_FIELD_ALIASES.put(201, TaskField.TEXT18);
        TASK_FIELD_ALIASES.put(202, TaskField.TEXT19);
        TASK_FIELD_ALIASES.put(203, TaskField.TEXT20);
        TASK_FIELD_ALIASES.put(204, TaskField.TEXT21);
        TASK_FIELD_ALIASES.put(205, TaskField.TEXT22);
        TASK_FIELD_ALIASES.put(206, TaskField.TEXT23);
        TASK_FIELD_ALIASES.put(207, TaskField.TEXT24);
        TASK_FIELD_ALIASES.put(208, TaskField.TEXT25);
        TASK_FIELD_ALIASES.put(209, TaskField.TEXT26);
        TASK_FIELD_ALIASES.put(210, TaskField.TEXT27);
        TASK_FIELD_ALIASES.put(211, TaskField.TEXT28);
        TASK_FIELD_ALIASES.put(212, TaskField.TEXT29);
        TASK_FIELD_ALIASES.put(213, TaskField.TEXT30);
        TASK_FIELD_ALIASES.put(214, TaskField.NUMBER11);
        TASK_FIELD_ALIASES.put(215, TaskField.NUMBER12);
        TASK_FIELD_ALIASES.put(216, TaskField.NUMBER13);
        TASK_FIELD_ALIASES.put(217, TaskField.NUMBER14);
        TASK_FIELD_ALIASES.put(218, TaskField.NUMBER15);
        TASK_FIELD_ALIASES.put(219, TaskField.NUMBER16);
        TASK_FIELD_ALIASES.put(220, TaskField.NUMBER17);
        TASK_FIELD_ALIASES.put(221, TaskField.NUMBER18);
        TASK_FIELD_ALIASES.put(222, TaskField.NUMBER19);
        TASK_FIELD_ALIASES.put(223, TaskField.NUMBER20);
        TASK_FIELD_ALIASES.put(227, TaskField.OUTLINE_CODE1);
        TASK_FIELD_ALIASES.put(228, TaskField.OUTLINE_CODE2);
        TASK_FIELD_ALIASES.put(229, TaskField.OUTLINE_CODE3);
        TASK_FIELD_ALIASES.put(230, TaskField.OUTLINE_CODE4);
        TASK_FIELD_ALIASES.put(231, TaskField.OUTLINE_CODE5);
        TASK_FIELD_ALIASES.put(232, TaskField.OUTLINE_CODE6);
        TASK_FIELD_ALIASES.put(233, TaskField.OUTLINE_CODE7);
        TASK_FIELD_ALIASES.put(234, TaskField.OUTLINE_CODE8);
        TASK_FIELD_ALIASES.put(235, TaskField.OUTLINE_CODE9);
        TASK_FIELD_ALIASES.put(236, TaskField.OUTLINE_CODE10);
        TASK_FIELD_ALIASES.put(237, TaskField.FLAG1);
        TASK_FIELD_ALIASES.put(238, TaskField.FLAG2);
        TASK_FIELD_ALIASES.put(239, TaskField.FLAG3);
        TASK_FIELD_ALIASES.put(240, TaskField.FLAG4);
        TASK_FIELD_ALIASES.put(241, TaskField.FLAG5);
        TASK_FIELD_ALIASES.put(242, TaskField.FLAG6);
        TASK_FIELD_ALIASES.put(243, TaskField.FLAG7);
        TASK_FIELD_ALIASES.put(244, TaskField.FLAG8);
        TASK_FIELD_ALIASES.put(245, TaskField.FLAG9);
        TASK_FIELD_ALIASES.put(246, TaskField.FLAG10);
        TASK_FIELD_ALIASES.put(247, TaskField.FLAG11);
        TASK_FIELD_ALIASES.put(248, TaskField.FLAG12);
        TASK_FIELD_ALIASES.put(249, TaskField.FLAG13);
        TASK_FIELD_ALIASES.put(250, TaskField.FLAG14);
        TASK_FIELD_ALIASES.put(251, TaskField.FLAG15);
        TASK_FIELD_ALIASES.put(252, TaskField.FLAG16);
        TASK_FIELD_ALIASES.put(253, TaskField.FLAG17);
        TASK_FIELD_ALIASES.put(254, TaskField.FLAG18);
        TASK_FIELD_ALIASES.put(255, TaskField.FLAG19);
        TASK_FIELD_ALIASES.put(256, TaskField.FLAG20);
        TASK_FIELD_ALIASES.put(278, TaskField.COST1);
        TASK_FIELD_ALIASES.put(279, TaskField.COST2);
        TASK_FIELD_ALIASES.put(280, TaskField.COST3);
        TASK_FIELD_ALIASES.put(281, TaskField.COST4);
        TASK_FIELD_ALIASES.put(282, TaskField.COST5);
        TASK_FIELD_ALIASES.put(283, TaskField.COST6);
        TASK_FIELD_ALIASES.put(284, TaskField.COST7);
        TASK_FIELD_ALIASES.put(285, TaskField.COST8);
        TASK_FIELD_ALIASES.put(286, TaskField.COST9);
        TASK_FIELD_ALIASES.put(287, TaskField.COST10);
    }
}

