/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.disasm.impl;

import io.github.skylot.raung.common.utils.FileUtils;
import io.github.skylot.raung.common.utils.ZipUtils;
import io.github.skylot.raung.disasm.impl.RaungDisasmBuilder;
import io.github.skylot.raung.disasm.impl.utils.RaungDisasmException;
import io.github.skylot.raung.disasm.impl.utils.ValidateDisasmArgs;
import io.github.skylot.raung.disasm.impl.visitors.RaungClassVisitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaungDisasmExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RaungDisasmExecutor.class);

    public static void process(RaungDisasmBuilder args) {
        ValidateDisasmArgs.process(args);
        RaungDisasmExecutor.processFiles(args);
    }

    public static String processSingleClass(RaungDisasmBuilder args, Path clsFile) {
        FileUtils.checkInputFile((Path)clsFile);
        ValidateDisasmArgs.processOptions(args);
        return RaungDisasmExecutor.runForSingleClass(args, clsFile).getResult();
    }

    public static String processInputStream(RaungDisasmBuilder args, InputStream in) throws IOException {
        ValidateDisasmArgs.processOptions(args);
        return RaungDisasmExecutor.runForInputStream(args, in).getResult();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RaungClassVisitor runForSingleClass(RaungDisasmBuilder args, Path clsFile) {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(clsFile, StandardOpenOption.READ));){
            RaungClassVisitor raungClassVisitor = RaungDisasmExecutor.runForInputStream(args, in);
            return raungClassVisitor;
        }
        catch (IOException e) {
            throw new RaungDisasmException("Failed to process class file: " + clsFile, e);
        }
    }

    private static RaungClassVisitor runForInputStream(RaungDisasmBuilder args, InputStream in) throws IOException {
        ClassReader reader = new ClassReader(in);
        RaungClassVisitor visitor = new RaungClassVisitor(args);
        reader.accept((ClassVisitor)visitor, 0);
        return visitor;
    }

    private static void processFiles(RaungDisasmBuilder args) {
        Path output = args.getOutput();
        boolean isOutputRaungFile = Objects.equals(FileUtils.getExt((Path)output), "raung");
        List inputFiles = FileUtils.expandDirs(args.getInputs());
        if (inputFiles.size() == 1 && ((Path)inputFiles.get(0)).getFileName().toString().endsWith(".class")) {
            Path inputFile = (Path)inputFiles.get(0);
            RaungClassVisitor rcv = RaungDisasmExecutor.runForSingleClass(args, inputFile);
            if (output == null) {
                String fileName = inputFile.getFileName().toString();
                String baseFileName = fileName.substring(0, fileName.length() - 6) + ".raung";
                Path raungFile = inputFile.toAbsolutePath().getParent().resolve(baseFileName);
                LOG.info("Saving to {}", (Object)raungFile);
                FileUtils.saveFile((Path)raungFile, (String)rcv.getResult());
                return;
            }
            if (isOutputRaungFile) {
                FileUtils.saveFile((Path)output, (String)rcv.getResult());
                return;
            }
            RaungDisasmExecutor.saveResult(args, rcv);
            return;
        }
        if (isOutputRaungFile || Files.isRegularFile(output, new LinkOption[0])) {
            throw new RaungDisasmException("Expect output to be directory, got file: " + output);
        }
        for (Path input : inputFiles) {
            RaungDisasmExecutor.runForFile(args, input);
        }
    }

    private static void runForFile(RaungDisasmBuilder args, Path inputFile) {
        String fileName = inputFile.getFileName().toString();
        if (fileName.endsWith(".class")) {
            RaungDisasmExecutor.saveResult(args, RaungDisasmExecutor.runForSingleClass(args, inputFile));
            return;
        }
        if (fileName.endsWith(".jar") || fileName.endsWith(".zip")) {
            RaungDisasmExecutor.runForZip(args, inputFile);
        }
    }

    private static void runForZip(RaungDisasmBuilder args, Path zipPath) {
        Path resDir = args.getOutput().resolve("resources");
        ZipUtils.visitZipEntries((File)zipPath.toFile(), (zip, entry) -> {
            String entryName = entry.getName();
            if (entryName.endsWith(".class")) {
                try (InputStream in = ZipUtils.getInputStreamForEntry((ZipFile)zip, (ZipEntry)entry);){
                    RaungDisasmExecutor.saveResult(args, RaungDisasmExecutor.runForInputStream(args, in));
                }
                catch (Exception e) {
                    LOG.error("Error process zip entry: {}", (Object)entry.getName(), (Object)e);
                }
            } else if (!entry.isDirectory()) {
                try (InputStream in = ZipUtils.getInputStreamForEntry((ZipFile)zip, (ZipEntry)entry);){
                    FileUtils.saveInputStream((Path)resDir, (String)entryName, (InputStream)in);
                }
                catch (Exception e) {
                    LOG.error("Error process zip entry: {}", (Object)entry.getName(), (Object)e);
                }
            }
            return null;
        });
    }

    private static void saveResult(RaungDisasmBuilder args, RaungClassVisitor rcv) {
        String fileName = rcv.getClsFullName().replace('/', File.separatorChar) + ".raung";
        FileUtils.saveFile((Path)args.getOutput(), (String)fileName, (String)rcv.getResult());
    }
}

