untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ5wrofYkEvhPM/gqaOggMqABF/CR2ddMpsEDhWDRXvADwvEyWN+8aE99LBy4EjXIBN9tRIVxXdFFpxAbAO2xSw4=

OpenBSD 6.0 errata 024, May 18, 2017:

Add a gap of 1MB between the stack and mmap spaces.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 024_exec_subr.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/exec_subr.c
===================================================================
RCS file: /cvs/src/sys/kern/exec_subr.c,v
retrieving revision 1.51
diff -u -p -r1.51 exec_subr.c
--- sys/kern/exec_subr.c	29 Aug 2015 05:40:01 -0000	1.51
+++ sys/kern/exec_subr.c	18 May 2017 18:56:53 -0000
@@ -315,6 +315,10 @@ vmcmd_randomize(struct proc *p, struct e
 	return (error);
 }
 
+#ifndef MAXSSIZ_GUARD
+#define MAXSSIZ_GUARD	(1024 * 1024)
+#endif
+
 /*
  * exec_setup_stack(): Set up the stack segment for an executable.
  *
@@ -336,7 +340,7 @@ exec_setup_stack(struct proc *p, struct 
 	epp->ep_maxsaddr = USRSTACK;
 	epp->ep_minsaddr = USRSTACK + MAXSSIZ;
 #else
-	epp->ep_maxsaddr = USRSTACK - MAXSSIZ;
+	epp->ep_maxsaddr = USRSTACK - MAXSSIZ - MAXSSIZ_GUARD;
 	epp->ep_minsaddr = USRSTACK;
 #endif
 	epp->ep_ssize = round_page(p->p_rlimit[RLIMIT_STACK].rlim_cur);
