untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwbX7iXjD5xfMa+QfnS2rGUqNUDGQJB00wNzmy40hrJMLBKhCCPNzFV8k2iTG0Snl6mY4rc4oZW1Sg6MHrpl+ewg=

OpenBSD 5.9 errata 27, Sep 22, 2016:

Avoid unbounded memory growth in libssl, which can be triggered by a TLS
client repeatedly renegotiating and sending OCSP Status Request TLS extensions.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 027_libssl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libssl:
	cd /usr/src/lib/libssl
	make obj
	make depend
	make
	make install

Index: lib/libssl/src/ssl/t1_lib.c
===================================================================
RCS file: /cvs/src/lib/libssl/src/ssl/Attic/t1_lib.c,v
retrieving revision 1.85
diff -u -p -r1.85 t1_lib.c
--- lib/libssl/src/ssl/t1_lib.c	12 Sep 2015 16:10:08 -0000	1.85
+++ lib/libssl/src/ssl/t1_lib.c	22 Sep 2016 17:41:22 -0000
@@ -1438,10 +1438,28 @@ ssl_parse_clienthello_tlsext(SSL *s, uns
 				/* Read in responder_id_list */
 				n2s(data, dsize);
 				size -= 2;
-				if (dsize > size  ) {
+				if (dsize > size) {
 					*al = SSL_AD_DECODE_ERROR;
 					return 0;
 				}
+
+				/*
+				 * We remove any OCSP_RESPIDs from a
+				 * previous handshake to prevent
+				 * unbounded memory growth.
+				 */
+				sk_OCSP_RESPID_pop_free(s->tlsext_ocsp_ids,
+				    OCSP_RESPID_free);
+				s->tlsext_ocsp_ids = NULL;
+				if (dsize > 0) {
+					s->tlsext_ocsp_ids =
+					    sk_OCSP_RESPID_new_null();
+					if (s->tlsext_ocsp_ids == NULL) {
+						*al = SSL_AD_INTERNAL_ERROR;
+						return 0;
+					}
+				}
+
 				while (dsize > 0) {
 					OCSP_RESPID *id;
 					int idsize;
@@ -1467,13 +1485,6 @@ ssl_parse_clienthello_tlsext(SSL *s, uns
 					if (data != sdata) {
 						OCSP_RESPID_free(id);
 						*al = SSL_AD_DECODE_ERROR;
-						return 0;
-					}
-					if (!s->tlsext_ocsp_ids &&
-					    !(s->tlsext_ocsp_ids =
-					    sk_OCSP_RESPID_new_null())) {
-						OCSP_RESPID_free(id);
-						*al = SSL_AD_INTERNAL_ERROR;
 						return 0;
 					}
 					if (!sk_OCSP_RESPID_push(
